/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.Kadmin;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminHandler;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminUtil;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.DefaultAdminHandler;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.InternalAdminClient;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.AddPrincipalRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.DeletePrincipalRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.GetprincsRequest;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.RenamePrincipalRequest;
import org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.kerby.kerberos.kerb.transport.KrbNetwork;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteKadminImpl
implements Kadmin {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteKadminImpl.class);
    private InternalAdminClient innerClient;
    private KrbTransport transport;

    public RemoteKadminImpl(InternalAdminClient innerClient) throws KrbException {
        this.innerClient = innerClient;
        TransportPair tpair = null;
        try {
            tpair = AdminUtil.getTransportPair(innerClient.getSetting());
        }
        catch (KrbException e) {
            LOG.error("Fail to get transport pair. " + e);
        }
        KrbNetwork network = new KrbNetwork();
        network.setSocketTimeout(innerClient.getSetting().getTimeout());
        try {
            this.transport = network.connect(tpair);
        }
        catch (IOException e) {
            throw new KrbException("Failed to create transport", (Throwable)e);
        }
    }

    public InternalAdminClient getInnerClient() {
        return this.innerClient;
    }

    @Override
    public String getKadminPrincipal() {
        return KrbUtil.makeKadminPrincipal(this.innerClient.getSetting().getKdcRealm()).getName();
    }

    @Override
    public void addPrincipal(String principal) throws KrbException {
        AddPrincipalRequest adRequest = new AddPrincipalRequest(principal);
        adRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(adRequest);
    }

    @Override
    public void addPrincipal(String principal, KOptions kOptions) throws KrbException {
        AddPrincipalRequest adRequest = new AddPrincipalRequest(principal, kOptions);
        adRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(adRequest);
    }

    @Override
    public void addPrincipal(String principal, String password) throws KrbException {
        AddPrincipalRequest addPrincipalRequest = new AddPrincipalRequest(principal, password);
        addPrincipalRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(addPrincipalRequest);
    }

    @Override
    public void addPrincipal(String principal, String password, KOptions kOptions) throws KrbException {
    }

    @Override
    public void exportKeytab(File keytabFile, String principal) throws KrbException {
    }

    @Override
    public void exportKeytab(File keytabFile, List<String> principals) throws KrbException {
    }

    @Override
    public void exportKeytab(File keytabFile) throws KrbException {
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal, int kvno) throws KrbException {
    }

    @Override
    public void removeOldKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
    }

    @Override
    public void deletePrincipal(String principal) throws KrbException {
        DeletePrincipalRequest deletePrincipalRequest = new DeletePrincipalRequest(principal);
        deletePrincipalRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(deletePrincipalRequest);
    }

    @Override
    public void modifyPrincipal(String principal, KOptions kOptions) throws KrbException {
    }

    @Override
    public void renamePrincipal(String oldPrincipalName, String newPrincipalName) throws KrbException {
        RenamePrincipalRequest renamePrincipalRequest = new RenamePrincipalRequest(oldPrincipalName, newPrincipalName);
        renamePrincipalRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        ((AdminHandler)adminHandler).handleRequest(renamePrincipalRequest);
    }

    @Override
    public List<String> getPrincipals() throws KrbException {
        GetprincsRequest grtPrincsRequest = new GetprincsRequest();
        grtPrincsRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        return ((AdminHandler)adminHandler).handleRequestForList(grtPrincsRequest);
    }

    @Override
    public List<String> getPrincipals(String globString) throws KrbException {
        GetprincsRequest grtPrincsRequest = new GetprincsRequest(globString);
        grtPrincsRequest.setTransport(this.transport);
        DefaultAdminHandler adminHandler = new DefaultAdminHandler();
        return ((AdminHandler)adminHandler).handleRequestForList(grtPrincsRequest);
    }

    @Override
    public void changePassword(String principal, String newPassword) throws KrbException {
    }

    @Override
    public void updateKeys(String principal) throws KrbException {
    }

    @Override
    public void release() throws KrbException {
    }
}

