/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.DiskFileDataSource;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.ParameterParser;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletRequestContext;
import org.apache.commons.io.Charsets;

public class MultipartFormDataBuilder
implements Builder {
    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        if (request == null) {
            throw new AxisFault("Cannot create DocumentElement without HttpServletRequest");
        }
        String charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEncoding == null) {
            charSetEncoding = request.getCharacterEncoding();
        }
        try {
            MultipleEntryHashMap parameterMap = this.getParameterMap(request, charSetEncoding);
            return BuilderUtil.buildsoapMessage(messageContext, parameterMap, OMAbstractFactory.getSOAP12Factory());
        }
        catch (FileUploadException e) {
            throw AxisFault.makeFault(e);
        }
    }

    private MultipleEntryHashMap getParameterMap(HttpServletRequest request, String charSetEncoding) throws FileUploadException {
        MultipleEntryHashMap parameterMap = new MultipleEntryHashMap();
        List items = MultipartFormDataBuilder.parseRequest(new JakartaServletRequestContext(request));
        for (DiskFileItem diskFileItem : items) {
            Object value;
            boolean isFormField = diskFileItem.isFormField();
            try {
                value = isFormField ? this.getTextParameter(diskFileItem, charSetEncoding) : this.getFileParameter(diskFileItem);
            }
            catch (Exception ex) {
                throw new FileUploadException(ex.getMessage());
            }
            parameterMap.put(diskFileItem.getFieldName(), value);
        }
        return parameterMap;
    }

    private static List parseRequest(JakartaServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory fileItemFactory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setCharset(StandardCharsets.UTF_8)).get();
        JakartaServletFileUpload upload = new JakartaServletFileUpload((FileItemFactory)fileItemFactory);
        upload.setFileCountMax(1L);
        return upload.parseRequest((RequestContext)requestContext);
    }

    private String getTextParameter(DiskFileItem diskFileItem, String characterEncoding) throws Exception {
        String encoding = null;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(diskFileItem.getContentType(), ';');
        encoding = (String)params.get("charset");
        if (encoding == null) {
            encoding = characterEncoding;
        }
        String textValue = encoding == null ? new String(diskFileItem.get()) : new String(diskFileItem.get(), Charsets.toCharset((Charset)diskFileItem.getCharset(), (Charset)StandardCharsets.ISO_8859_1));
        return textValue;
    }

    private DataHandler getFileParameter(DiskFileItem diskFileItem) throws Exception {
        DiskFileDataSource dataSource = new DiskFileDataSource(diskFileItem);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        return dataHandler;
    }
}

