/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.AdditionalMetadataLocation;
import org.opensaml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml2.metadata.ContactPerson;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class EntityDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        EntityDescriptor entityDescriptor = (EntityDescriptor)parentSAMLObject;
        if (childSAMLObject instanceof Extensions) {
            entityDescriptor.setExtensions((Extensions)childSAMLObject);
        } else if (childSAMLObject instanceof Signature) {
            entityDescriptor.setSignature((Signature)childSAMLObject);
        } else if (childSAMLObject instanceof RoleDescriptor) {
            entityDescriptor.getRoleDescriptors().add((RoleDescriptor)childSAMLObject);
        } else if (childSAMLObject instanceof AffiliationDescriptor) {
            entityDescriptor.setAffiliationDescriptor((AffiliationDescriptor)childSAMLObject);
        } else if (childSAMLObject instanceof Organization) {
            entityDescriptor.setOrganization((Organization)childSAMLObject);
        } else if (childSAMLObject instanceof ContactPerson) {
            entityDescriptor.getContactPersons().add((ContactPerson)childSAMLObject);
        } else if (childSAMLObject instanceof AdditionalMetadataLocation) {
            entityDescriptor.getAdditionalMetadataLocations().add((AdditionalMetadataLocation)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        EntityDescriptor entityDescriptor = (EntityDescriptor)samlObject;
        if (attribute.getLocalName().equals("entityID")) {
            entityDescriptor.setEntityID(attribute.getValue());
        } else if (attribute.getLocalName().equals("ID")) {
            entityDescriptor.setID(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else if (attribute.getLocalName().equals("validUntil") && !DatatypeHelper.isEmpty((String)attribute.getValue())) {
            entityDescriptor.setValidUntil(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if (attribute.getLocalName().equals("cacheDuration")) {
            entityDescriptor.setCacheDuration(XMLHelper.durationToLong((String)attribute.getValue()));
        } else {
            QName attribQName = XMLHelper.getNodeQName((Node)attribute);
            if (attribute.isId()) {
                entityDescriptor.getUnknownAttributes().registerID(attribQName);
            }
            entityDescriptor.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }
}

