/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.locale.BaseLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateLocaleConverter<D extends Date>
extends BaseLocaleConverter<D> {
    private static final String DEFAULT_PATTERN_CHARS = DateLocaleConverter.initDefaultChars();
    private static final Log LOG = LogFactory.getLog(DateLocaleConverter.class);
    private final boolean isLenient;

    public static <B extends Builder<B, D>, D extends Date> B builder() {
        return (B)new Builder();
    }

    private static String initDefaultChars() {
        return new DateFormatSymbols(Locale.US).getLocalPatternChars();
    }

    protected DateLocaleConverter(D defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern, boolean lenient) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
        this.isLenient = lenient;
    }

    private String convertLocalizedPattern(String localizedPattern, Locale locale) {
        String convertedPattern;
        block4: {
            if (localizedPattern == null) {
                return null;
            }
            DateFormatSymbols localizedSymbols = new DateFormatSymbols(locale);
            String localChars = localizedSymbols.getLocalPatternChars();
            if (DEFAULT_PATTERN_CHARS.equals(localChars)) {
                return localizedPattern;
            }
            convertedPattern = null;
            try {
                convertedPattern = this.convertPattern(localizedPattern, localChars, DEFAULT_PATTERN_CHARS);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Converting pattern '" + localizedPattern + "' for " + locale), (Throwable)ex);
            }
        }
        return convertedPattern;
    }

    private String convertPattern(String pattern, String fromChars, String toChars) {
        StringBuilder converted = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char thisChar = pattern.charAt(i);
            if (quoted) {
                if (thisChar == '\'') {
                    quoted = false;
                }
            } else if (thisChar == '\'') {
                quoted = true;
            } else if (thisChar >= 'a' && thisChar <= 'z' || thisChar >= 'A' && thisChar <= 'Z') {
                int index = fromChars.indexOf(thisChar);
                if (index == -1) {
                    throw new IllegalArgumentException("Illegal pattern character '" + thisChar + "'");
                }
                thisChar = toChars.charAt(index);
            }
            converted.append(thisChar);
        }
        if (quoted) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return converted.toString();
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    @Override
    protected D parse(Object value, String pattern) throws ParseException {
        if (value instanceof Date) {
            return (D)((Date)value);
        }
        if (value instanceof Calendar) {
            return (D)((Calendar)value).getTime();
        }
        if (this.localizedPattern) {
            pattern = this.convertLocalizedPattern(pattern, this.locale);
        }
        DateFormat formatter = pattern == null ? DateFormat.getDateInstance(3, this.locale) : new SimpleDateFormat(pattern, this.locale);
        formatter.setLenient(this.isLenient);
        ParsePosition pos = new ParsePosition(0);
        String strValue = value.toString();
        Object parsedValue = formatter.parseObject(strValue, pos);
        if (pos.getErrorIndex() > -1) {
            throw ConversionException.format("Error parsing date '%s' at position = %s", value, pos.getErrorIndex());
        }
        if (pos.getIndex() < strValue.length()) {
            throw ConversionException.format("Date '%s' contains unparsed characters from position = %s", value, pos.getIndex());
        }
        return (D)((Date)parsedValue);
    }

    public static class Builder<B extends Builder<B, D>, D extends Date>
    extends BaseLocaleConverter.Builder<B, D> {
        private boolean lenient;

        @Override
        public DateLocaleConverter<D> get() {
            return new DateLocaleConverter<Date>((Date)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern, this.lenient);
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public B setLenient(boolean lenient) {
            this.lenient = lenient;
            return (B)((Builder)this.asThis());
        }
    }
}

