/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import org.apache.commons.compress.archivers.cpio.CpioUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CpioUtilTest {
    CpioUtilTest() {
    }

    @Test
    void testByteArray2longThrowsUnsupportedOperationException() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CpioUtil.byteArray2long((byte[])new byte[1], (boolean)true));
    }

    @Test
    void testLong2byteArrayWithPositiveThrowsUnsupportedOperationException() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CpioUtil.long2byteArray((long)0L, (int)1021, (boolean)false));
    }

    @Test
    void testLong2byteArrayWithZeroThrowsUnsupportedOperationException() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CpioUtil.long2byteArray((long)0L, (int)0, (boolean)false));
    }

    @Test
    void testOldBinMagic2ByteArrayNotSwapped() {
        Assertions.assertArrayEquals((byte[])new byte[]{-57, 113}, (byte[])CpioUtil.long2byteArray((long)29127L, (int)2, (boolean)false));
    }

    @Test
    void testOldBinMagic2ByteArraySwapped() {
        Assertions.assertArrayEquals((byte[])new byte[]{113, -57}, (byte[])CpioUtil.long2byteArray((long)29127L, (int)2, (boolean)true));
    }

    @Test
    void testOldBinMagicFromByteArrayNotSwapped() {
        Assertions.assertEquals((long)29127L, (long)CpioUtil.byteArray2long((byte[])new byte[]{-57, 113}, (boolean)false));
    }

    @Test
    void testOldBinMagicFromByteArraySwapped() {
        Assertions.assertEquals((long)29127L, (long)CpioUtil.byteArray2long((byte[])new byte[]{113, -57}, (boolean)true));
    }
}

