/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOStream;
import org.apache.commons.io.input.RandomAccessFileInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class GzipCompressorInputStreamTest {
    @TempDir
    Path tempDir;

    GzipCompressorInputStreamTest() {
    }

    private List<Path> extractMembers(String sourceGzipPath) throws IOException {
        ArrayList members = new ArrayList();
        Path tempFile = this.tempDir.resolve("temp.bin");
        try (OutputStream fos = Files.newOutputStream(tempFile, new OpenOption[0]);
             GzipCompressorInputStream gis = ((GzipCompressorInputStream.Builder)GzipCompressorInputStream.builder().setFile(sourceGzipPath)).setDecompressConcatenated(true).setOnMemberEnd(in -> members.add(in.getMetaData())).get();){
            IOUtils.copy((InputStream)gis, (OutputStream)fos);
        }
        ArrayList<Path> resolved = new ArrayList<Path>(members.size());
        AtomicLong startPos = new AtomicLong();
        try (RandomAccessFileInputStream rafIs = ((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setPath(tempFile)).setCloseOnClose(true).get();){
            IOStream.of(members).forEach(e -> {
                Path member = this.tempDir.resolve(e.getFileName());
                resolved.add(member);
                try (OutputStream os = Files.newOutputStream(member, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);){
                    startPos.addAndGet(rafIs.copy(startPos.get(), e.getTrailerISize(), os));
                }
            });
        }
        return resolved;
    }

    @Test
    @Disabled
    void testGzipParametersMembersIo() throws IOException {
        Path targetFile = this.tempDir.resolve("test.gz");
        String sourceFileName1 = "file1";
        String sourceFileName2 = "file2";
        Path tempSourceFile1 = this.tempDir.resolve("file1");
        Path tempSourceFile2 = this.tempDir.resolve("file2");
        byte[] bytes1 = "<text>Hello World 1!</text>".getBytes(StandardCharsets.UTF_8);
        byte[] bytes2 = "<text>Hello World 2!</text>".getBytes(StandardCharsets.UTF_8);
        Files.write(tempSourceFile1, bytes1, new OpenOption[0]);
        Files.write(tempSourceFile2, bytes2, new OpenOption[0]);
        GzipParameters parameters1 = new GzipParameters();
        GzipParameters parameters2 = new GzipParameters();
        parameters1.setFileName("file1");
        parameters2.setFileName("file2");
        try (OutputStream fos = Files.newOutputStream(targetFile, new OpenOption[0]);
             GzipCompressorOutputStream gos = new GzipCompressorOutputStream(fos, parameters1);){
            gos.write(tempSourceFile1);
            gos.finish();
            gos.write(tempSourceFile2);
            gos.finish();
        }
        try (GzipCompressorInputStream gis = ((GzipCompressorInputStream.Builder)GzipCompressorInputStream.builder().setPath(targetFile)).setDecompressConcatenated(false).get();){
            Assertions.assertEquals((Object)parameters1, (Object)gis.getMetaData());
            Assertions.assertArrayEquals((byte[])bytes1, (byte[])IOUtils.toByteArray((InputStream)gis));
        }
        gis = ((GzipCompressorInputStream.Builder)GzipCompressorInputStream.builder().setPath(targetFile)).setDecompressConcatenated(true).get();
        try {
            Assertions.assertEquals((Object)parameters1, (Object)gis.getMetaData());
        }
        finally {
            if (gis != null) {
                gis.close();
            }
        }
    }

    @Test
    void testOnMemberFirstAll() throws IOException {
        ArrayList parametersStart = new ArrayList();
        ArrayList parametersEnd = new ArrayList();
        try (GzipCompressorInputStream gis = ((GzipCompressorInputStream.Builder)GzipCompressorInputStream.builder().setFile("src/test/resources/org/apache/commons/compress/gzip/members.gz")).setDecompressConcatenated(true).setOnMemberStart(in -> parametersStart.add(in.getMetaData())).setOnMemberEnd(in -> parametersEnd.add(in.getMetaData())).get();){
            Assertions.assertEquals((Object)"hello1.txt", (Object)gis.getMetaData().getFileName());
            Assertions.assertEquals((Object)"Hello1\nHello2\n", (Object)IOUtils.toString((InputStream)gis, (Charset)StandardCharsets.ISO_8859_1));
            Assertions.assertEquals((Object)"hello2.txt", (Object)gis.getMetaData().getFileName());
        }
        Assertions.assertEquals((int)2, (int)parametersStart.size());
        Assertions.assertEquals((int)2, (int)parametersEnd.size());
        Assertions.assertEquals(parametersStart, parametersEnd);
        Assertions.assertEquals((int)2, (int)new HashSet(parametersStart).size());
        Assertions.assertEquals((int)2, (int)new HashSet(parametersEnd).size());
        Assertions.assertEquals((long)4202744527L, (long)((GzipParameters)parametersEnd.get(0)).getTrailerCrc());
        Assertions.assertEquals((long)7L, (long)((GzipParameters)parametersEnd.get(0)).getTrailerISize());
        Assertions.assertEquals((long)3517815052L, (long)((GzipParameters)parametersEnd.get(1)).getTrailerCrc());
        Assertions.assertEquals((long)7L, (long)((GzipParameters)parametersEnd.get(1)).getTrailerISize());
    }

    @Test
    void testOnMemberFirstOnly() throws IOException {
        ArrayList parametersStart = new ArrayList();
        ArrayList parametersEnd = new ArrayList();
        try (GzipCompressorInputStream gis = ((GzipCompressorInputStream.Builder)GzipCompressorInputStream.builder().setFile("src/test/resources/org/apache/commons/compress/gzip/members.gz")).setDecompressConcatenated(false).setOnMemberStart(in -> parametersStart.add(in.getMetaData())).setOnMemberEnd(in -> parametersEnd.add(in.getMetaData())).get();){
            Assertions.assertEquals((Object)"hello1.txt", (Object)gis.getMetaData().getFileName());
            Assertions.assertEquals((Object)"Hello1\n", (Object)IOUtils.toString((InputStream)gis, (Charset)StandardCharsets.ISO_8859_1));
            Assertions.assertEquals((Object)"hello1.txt", (Object)gis.getMetaData().getFileName());
        }
        Assertions.assertEquals((int)1, (int)parametersStart.size());
        Assertions.assertEquals((int)1, (int)parametersEnd.size());
        Assertions.assertEquals(parametersStart, parametersEnd);
        Assertions.assertEquals((long)4202744527L, (long)((GzipParameters)parametersEnd.get(0)).getTrailerCrc());
        Assertions.assertEquals((long)7L, (long)((GzipParameters)parametersEnd.get(0)).getTrailerISize());
    }

    @Test
    void testOnMemberSaveAsFiles() throws IOException {
        List<Path> resolved = this.extractMembers("src/test/resources/org/apache/commons/compress/gzip/members.gz");
        Assertions.assertEquals((Object)"Hello1\n", (Object)PathUtils.readString((Path)resolved.get(0), (Charset)StandardCharsets.ISO_8859_1));
        Assertions.assertEquals((Object)"Hello2\n", (Object)PathUtils.readString((Path)resolved.get(1), (Charset)StandardCharsets.ISO_8859_1));
    }

    @Test
    void testOnMemberSaveAsSize0Files() throws IOException {
        List<Path> resolved = this.extractMembers("src/test/resources/org/apache/commons/compress/gzip/members-size-0.gz");
        Assertions.assertEquals((int)3, (int)resolved.size());
        IOStream.of(resolved).forEach(p -> {
            Assertions.assertEquals((long)0L, (long)Files.size(p));
            Assertions.assertEquals((Object)"", (Object)PathUtils.readString((Path)p, (Charset)StandardCharsets.ISO_8859_1));
        });
    }

    @Test
    void testReadGzipFileCreatedByCli() throws IOException {
        try (GzipCompressorInputStream gis = ((GzipCompressorInputStream.Builder)GzipCompressorInputStream.builder().setFile("src/test/resources/org/apache/commons/compress/gzip/members.gz")).get();){
            Assertions.assertEquals((Object)"hello1.txt", (Object)gis.getMetaData().getFileName());
            Assertions.assertEquals((Object)"Hello1\n", (Object)IOUtils.toString((InputStream)gis, (Charset)StandardCharsets.ISO_8859_1));
            Assertions.assertEquals((Object)"hello1.txt", (Object)gis.getMetaData().getFileName());
        }
        gis = ((GzipCompressorInputStream.Builder)GzipCompressorInputStream.builder().setFile("src/test/resources/org/apache/commons/compress/gzip/members.gz")).setDecompressConcatenated(true).get();
        try {
            Assertions.assertEquals((Object)"hello1.txt", (Object)gis.getMetaData().getFileName());
            Assertions.assertEquals((Object)"Hello1\nHello2\n", (Object)IOUtils.toString((InputStream)gis, (Charset)StandardCharsets.ISO_8859_1));
            Assertions.assertEquals((Object)"hello2.txt", (Object)gis.getMetaData().getFileName());
        }
        finally {
            if (gis != null) {
                gis.close();
            }
        }
    }
}

