/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd.dataparsers;

import java.util.Arrays;
import org.apache.commons.imaging.formats.psd.PsdImageContents;
import org.apache.commons.imaging.formats.psd.dataparsers.AbstractDataParser;

public class DataParserIndexed
extends AbstractDataParser {
    private final int[] colorTable = new int[256];

    public DataParserIndexed(byte[] colorModeData) {
        Arrays.setAll(this.colorTable, i -> {
            int red = 0xFF & colorModeData[0 + i];
            int green = 0xFF & colorModeData[256 + i];
            int blue = 0xFF & colorModeData[512 + i];
            int alpha = 255;
            return 0xFF000000 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        });
    }

    @Override
    public int getBasicChannelsCount() {
        return 1;
    }

    @Override
    protected int getRgb(int[][][] data, int x, int y, PsdImageContents imageContents) {
        int sample = 0xFF & data[0][y][x];
        return this.colorTable[sample];
    }
}

