/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.TiffTags;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class TiffField {
    private static final Logger LOGGER = Logger.getLogger(TiffField.class.getName());
    private final TagInfo tagInfo;
    private final int tag;
    private final int directoryType;
    private final AbstractFieldType abstractFieldType;
    private final long count;
    private final long offset;
    private final byte[] value;
    private final ByteOrder byteOrder;
    private final int sortHint;

    public TiffField(int tag, int directoryType, AbstractFieldType abstractFieldType, long count, long offset, byte[] value, ByteOrder byteOrder, int sortHint) {
        this.tag = tag;
        this.directoryType = directoryType;
        this.abstractFieldType = abstractFieldType;
        this.count = count;
        this.offset = offset;
        this.value = value;
        this.byteOrder = byteOrder;
        this.sortHint = sortHint;
        this.tagInfo = TiffTags.getTag(directoryType, tag);
    }

    public void dump() {
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            this.dump(pw);
            pw.flush();
            sw.flush();
            LOGGER.fine(sw.toString());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, null);
    }

    public void dump(PrintWriter pw, String prefix) {
        if (prefix != null) {
            pw.print(prefix + ": ");
        }
        pw.println(this.toString());
        pw.flush();
    }

    public byte[] getByteArrayValue() {
        return BinaryFunctions.copyOfStart(this.value, this.getBytesLength());
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getBytesLength() {
        return (int)this.count * this.abstractFieldType.getSize();
    }

    public long getCount() {
        return this.count;
    }

    public String getDescriptionWithoutValue() {
        return this.getTag() + " (0x" + Integer.toHexString(this.getTag()) + ": " + this.getTagInfo().name + "): ";
    }

    public int getDirectoryType() {
        return this.directoryType;
    }

    public double[] getDoubleArrayValue() throws ImagingException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return new double[]{((Number)o).doubleValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            double[] result = Allocator.doubleArray(numbers.length);
            Arrays.setAll(result, i -> numbers[i].doubleValue());
            return result;
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            double[] result = Allocator.doubleArray(numbers.length);
            Arrays.setAll(result, i -> numbers[i]);
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            double[] result = Allocator.doubleArray(numbers.length);
            Arrays.setAll(result, i -> numbers[i]);
            return result;
        }
        if (o instanceof float[]) {
            float[] numbers = (float[])o;
            double[] result = Allocator.doubleArray(numbers.length);
            Arrays.setAll(result, i -> numbers[i]);
            return result;
        }
        if (o instanceof double[]) {
            double[] numbers = (double[])o;
            return Arrays.copyOf(numbers, numbers.length);
        }
        throw new ImagingException("Unknown value: " + o + " for: " + this.getTagInfo().getDescription());
    }

    public double getDoubleValue() throws ImagingException {
        Object o = this.getValue();
        if (o == null) {
            throw new ImagingException("Missing value: " + this.getTagInfo().getDescription());
        }
        return ((Number)o).doubleValue();
    }

    public AbstractFieldType getFieldType() {
        return this.abstractFieldType;
    }

    public String getFieldTypeName() {
        return this.getFieldType().getName();
    }

    public int[] getIntArrayValue() throws ImagingException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return new int[]{((Number)o).intValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int[] result = Allocator.intArray(numbers.length);
            Arrays.setAll(result, i -> numbers[i].intValue());
            return result;
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            int[] result = Allocator.intArray(numbers.length);
            Arrays.setAll(result, i -> 0xFFFF & numbers[i]);
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            return Arrays.copyOf(numbers, numbers.length);
        }
        if (o instanceof long[]) {
            long[] numbers = (long[])o;
            int[] iNumbers = new int[numbers.length];
            for (int i2 = 0; i2 < iNumbers.length; ++i2) {
                iNumbers[i2] = (int)numbers[i2];
            }
            return iNumbers;
        }
        throw new ImagingException("Unknown value: " + o + " for: " + this.getTagInfo().getDescription());
    }

    public int getIntValue() throws ImagingException {
        Object o = this.getValue();
        if (o == null) {
            throw new ImagingException("Missing value: " + this.getTagInfo().getDescription());
        }
        return ((Number)o).intValue();
    }

    public int getIntValueOrArraySum() throws ImagingException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int sum = 0;
            for (Number number : numbers) {
                sum += number.intValue();
            }
            return sum;
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            int sum = 0;
            for (short number : numbers) {
                sum += number;
            }
            return sum;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int sum = 0;
            for (int number : numbers) {
                sum += number;
            }
            return sum;
        }
        throw new ImagingException("Unknown value: " + o + " for: " + this.getTagInfo().getDescription());
    }

    public long[] getLongArrayValue() throws ImagingException {
        Object o = this.getValue();
        if (o instanceof Number) {
            return new long[]{((Number)o).longValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            long[] result = Allocator.longArray(numbers.length);
            Arrays.setAll(result, i -> numbers[i].longValue());
            return result;
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            long[] result = Allocator.longArray(numbers.length);
            Arrays.setAll(result, i -> 0xFFFF & numbers[i]);
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            long[] result = Allocator.longArray(numbers.length);
            Arrays.setAll(result, i -> 0xFFFFFFFFL & (long)numbers[i]);
            return result;
        }
        if (o instanceof long[]) {
            long[] numbers = (long[])o;
            return Arrays.copyOf(numbers, numbers.length);
        }
        throw new ImagingException("Unknown value: " + o + " for: " + this.getTagInfo().getDescription());
    }

    public long getLongValue() throws ImagingException {
        Object o = this.getValue();
        if (o == null) {
            throw new ImagingException("Missing value: " + this.getTagInfo().getDescription());
        }
        return ((Number)o).longValue();
    }

    public int getOffset() {
        return (int)this.offset;
    }

    public AbstractTiffElement getOversizeValueElement() {
        if (this.isLocalValue()) {
            return null;
        }
        return new OversizeValueElement(this.getOffset(), this.value.length);
    }

    public int getSortHint() {
        return this.sortHint;
    }

    public String getStringValue() throws ImagingException {
        Object o = this.getValue();
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            throw new ImagingException("Expected String value(" + this.getTagInfo().getDescription() + "): " + o);
        }
        return (String)o;
    }

    public int getTag() {
        return this.tag;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public String getTagName() {
        if (this.getTagInfo() == TiffTagConstants.TIFF_TAG_UNKNOWN) {
            return this.getTagInfo().name + " (0x" + Integer.toHexString(this.getTag()) + ")";
        }
        return this.getTagInfo().name;
    }

    public Object getValue() throws ImagingException {
        return this.getTagInfo().getValue(this);
    }

    public String getValueDescription() {
        try {
            return this.getValueDescription(this.getValue());
        }
        catch (ImagingException e) {
            return "Invalid value: " + e.getMessage();
        }
    }

    private String getValueDescription(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            return "'" + o.toString().trim() + "'";
        }
        if (o instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ROOT);
            return df.format((Date)o);
        }
        if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (i > 50) {
                    result.append("... (").append(objects.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(object.toString());
            }
            return result.toString();
        }
        if (o instanceof short[]) {
            short[] values = (short[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                short sVal = values[i];
                if (i > 50) {
                    result.append("... (").append(values.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(sVal);
            }
            return result.toString();
        }
        if (o instanceof int[]) {
            int[] values = (int[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                int iVal = values[i];
                if (i > 50) {
                    result.append("... (").append(values.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(iVal);
            }
            return result.toString();
        }
        if (o instanceof long[]) {
            long[] values = (long[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                long lVal = values[i];
                if (i > 50) {
                    result.append("... (").append(values.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(lVal);
            }
            return result.toString();
        }
        if (o instanceof double[]) {
            double[] values = (double[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                double dVal = values[i];
                if (i > 50) {
                    result.append("... (").append(values.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(dVal);
            }
            return result.toString();
        }
        if (o instanceof byte[]) {
            byte[] values = (byte[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                byte bVal = values[i];
                if (i > 50) {
                    result.append("... (").append(values.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(bVal);
            }
            return result.toString();
        }
        if (o instanceof char[]) {
            char[] values = (char[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                char cVal = values[i];
                if (i > 50) {
                    result.append("... (").append(values.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(cVal);
            }
            return result.toString();
        }
        if (o instanceof float[]) {
            float[] values = (float[])o;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                float fVal = values[i];
                if (i > 50) {
                    result.append("... (").append(values.length).append(")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append(fVal);
            }
            return result.toString();
        }
        return "Unknown: " + o.getClass().getName();
    }

    public boolean isLocalValue() {
        return this.count * (long)this.abstractFieldType.getSize() <= 4L;
    }

    public String toString() {
        return this.getTag() + " (0x" + Integer.toHexString(this.getTag()) + ": " + this.getTagInfo().name + "): " + this.getValueDescription() + " (" + this.getCount() + " " + this.getFieldType().getName() + ")";
    }

    public final class OversizeValueElement
    extends AbstractTiffElement {
        public OversizeValueElement(int offset, int length) {
            super(offset, length);
        }

        @Override
        public String getElementDescription() {
            return "OversizeValueElement, tag: " + TiffField.this.getTagInfo().name + ", fieldType: " + TiffField.this.getFieldType().getName();
        }
    }
}

