/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.internal.introspection.PermissionsParser;

public interface JexlPermissions {
    public static final JexlPermissions UNRESTRICTED = JexlPermissions.parse(new String[0]);
    public static final JexlPermissions RESTRICTED = JexlPermissions.parse("# Restricted Uberspect Permissions", "java.nio.*", "java.io.*", "java.lang.*", "java.math.*", "java.text.*", "java.util.*", "org.w3c.dom.*", "org.apache.commons.jexl3.*", "org.apache.commons.jexl3 { JexlBuilder {} }", "org.apache.commons.jexl3.introspection { JexlPermissions {} JexlPermissions$ClassPermissions {} }", "org.apache.commons.jexl3.internal { Engine {} Engine32 {} TemplateEngine {} }", "org.apache.commons.jexl3.internal.introspection { Uberspect {} Introspector {} }", "java.lang { Runtime{} System{} ProcessBuilder{} Process{} RuntimePermission{} SecurityManager{} Thread{} ThreadGroup{} Class{} }", "java.lang.annotation {}", "java.lang.instrument {}", "java.lang.invoke {}", "java.lang.management {}", "java.lang.ref {}", "java.lang.reflect {}", "java.net {}", "java.io { File{} FileDescriptor{} }", "java.nio { Path { } Paths { } Files { } }", "java.rmi");

    public static JexlPermissions parse(String ... src) {
        return new PermissionsParser().parse(src);
    }

    public boolean allow(Class<?> var1);

    public boolean allow(Constructor<?> var1);

    public boolean allow(Field var1);

    public boolean allow(Method var1);

    public boolean allow(Package var1);

    public JexlPermissions compose(String ... var1);

    default public boolean validate(Class<?> clazz) {
        return clazz != null;
    }

    default public boolean validate(Constructor<?> constructor) {
        return constructor != null && Modifier.isPublic(constructor.getModifiers());
    }

    default public boolean validate(Field field) {
        return field != null && Modifier.isPublic(field.getModifiers());
    }

    default public boolean validate(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers());
    }

    default public boolean validate(Package pack) {
        return pack != null;
    }

    public static class Delegate
    implements JexlPermissions {
        protected final JexlPermissions base;

        protected Delegate(JexlPermissions delegate) {
            this.base = delegate;
        }

        @Override
        public boolean allow(Class<?> clazz) {
            return this.base.allow(clazz);
        }

        @Override
        public boolean allow(Constructor<?> ctor) {
            return this.base.allow(ctor);
        }

        @Override
        public boolean allow(Field field) {
            return this.base.allow(field);
        }

        @Override
        public boolean allow(Method method) {
            return this.base.allow(method);
        }

        @Override
        public boolean allow(Package pack) {
            return this.base.allow(pack);
        }

        @Override
        public JexlPermissions compose(String ... src) {
            return new Delegate(this.base.compose(src));
        }
    }

    public static final class ClassPermissions
    extends Delegate {
        private final Set<String> allowedClasses;

        public ClassPermissions(Class<?> ... allow) {
            this(RESTRICTED, Arrays.stream(Objects.requireNonNull(allow)).map(Class::getCanonicalName).collect(Collectors.toList()));
        }

        public ClassPermissions(JexlPermissions delegate, Collection<String> allow) {
            super(Objects.requireNonNull(delegate));
            this.allowedClasses = new HashSet<String>(Objects.requireNonNull(allow));
        }

        @Override
        public boolean allow(Class<?> clazz) {
            return this.validate(clazz) && this.isClassAllowed(clazz) || super.allow(clazz);
        }

        @Override
        public boolean allow(Constructor<?> constructor) {
            return this.validate(constructor) && this.isClassAllowed(constructor.getDeclaringClass()) || super.allow(constructor);
        }

        @Override
        public boolean allow(Method method) {
            return this.validate(method) && this.isClassAllowed(method.getDeclaringClass()) || super.allow(method);
        }

        @Override
        public JexlPermissions compose(String ... src) {
            return new ClassPermissions(this.base.compose(src), this.allowedClasses);
        }

        private boolean isClassAllowed(Class<?> clazz) {
            return this.allowedClasses.contains(clazz.getCanonicalName());
        }
    }
}

