/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption.keys.content.derivedKey;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.keys.content.derivedKey.DerivationAlgorithm;
import org.apache.xml.security.encryption.params.HKDFParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HKDF
implements DerivationAlgorithm<HKDFParams> {
    private static final Logger LOG = LoggerFactory.getLogger(HKDF.class);

    @Override
    public byte[] deriveKey(byte[] secret, HKDFParams params) throws XMLSecurityException {
        if (params == null) {
            throw new IllegalArgumentException(I18n.translate("KeyDerivation.MissingParameters"));
        }
        String jceAlgorithmName = JCEMapper.translateURItoJCEID(params.getHmacHashAlgorithm());
        if (jceAlgorithmName == null) {
            throw new XMLSecurityException("KeyDerivation.NotSupportedParameter", new Object[]{params.getHmacHashAlgorithm()});
        }
        byte[] prk = this.extractKey(jceAlgorithmName, params.getSalt(), secret);
        return this.expandKey(jceAlgorithmName, prk, params.getInfo(), params.getKeyLength());
    }

    public byte[] extractKey(String jceAlgorithmName, byte[] salt, byte[] secret) throws XMLSecurityException {
        Mac hMac = this.initHMac(jceAlgorithmName, salt, true);
        hMac.reset();
        return hMac.doFinal(secret);
    }

    public byte[] expandKey(String jceHmacAlgorithmName, byte[] prk, byte[] info, long keyLength) throws XMLSecurityException {
        Mac hMac = this.initHMac(jceHmacAlgorithmName, prk, false);
        int iMacLength = hMac.getMacLength();
        int toGenerateSize = (int)keyLength;
        ByteBuffer result = ByteBuffer.allocate(toGenerateSize);
        byte[] prevResult = new byte[]{};
        int counter = 1;
        while (toGenerateSize > 0) {
            hMac.reset();
            hMac.update(prevResult);
            if (info != null && info.length > 0) {
                hMac.update(info);
            }
            hMac.update((byte)counter);
            prevResult = hMac.doFinal();
            result.put(prevResult, 0, Math.min(toGenerateSize, iMacLength));
            toGenerateSize -= iMacLength;
            counter = (short)(counter + 1);
        }
        return result.array();
    }

    private Mac initHMac(String jceAlgorithmName, byte[] initSecret, boolean initPRK) throws XMLSecurityException {
        Mac mac;
        try {
            LOG.debug("Init Mac with hash algorithm: [{}]", (Object)jceAlgorithmName);
            mac = Mac.getInstance(jceAlgorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XMLSecurityException(e, "KeyDerivation.NotSupportedParameter", new Object[]{jceAlgorithmName});
        }
        if (initPRK && (initSecret == null || initSecret.length == 0)) {
            LOG.debug("Init Mac with hmac algorithm [{}] and empty salt!", (Object)jceAlgorithmName);
            initSecret = new byte[mac.getMacLength()];
        }
        SecretKeySpec secretKey = new SecretKeySpec(initSecret, jceAlgorithmName);
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException e) {
            throw new XMLSecurityException(e);
        }
        return mac;
    }
}

