/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.ProducerField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerProducer;

public class ProducerFilterPredicate
extends ActiveMQFilterPredicate<ServerProducer> {
    private ProducerField f;
    private final ActiveMQServer server;

    public ProducerFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(ServerProducer producer) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case ID: {
                return this.matches(producer.getID());
            }
            case CONNECTION_ID: {
                return this.matches(producer.getConnectionID());
            }
            case SESSION: {
                return this.matches(producer.getSessionID());
            }
            case USER: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getUsername());
            }
            case VALIDATED_USER: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getValidatedUser());
            }
            case ADDRESS: {
                return this.matches(producer.getAddress() != null ? producer.getAddress() : this.server.getSessionByID(producer.getSessionID()).getDefaultAddress());
            }
            case PROTOCOL: {
                return this.matches(producer.getProtocol());
            }
            case CLIENT_ID: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getClientID());
            }
            case LOCAL_ADDRESS: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getTransportConnection().getLocalAddress());
            }
            case REMOTE_ADDRESS: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getTransportConnection().getRemoteAddress());
            }
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = ProducerField.valueOfName(field);
            if (this.f == null) {
                this.f = ProducerField.valueOf(field);
            }
        }
    }
}

