/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.metadata.support.AttributeConsumingServiceSelector;
import org.opensaml.saml.metadata.support.SAML2MetadataSupport;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.SSODescriptorImpl;

public class SPSSODescriptorImpl
extends SSODescriptorImpl
implements SPSSODescriptor {
    @Nullable
    private XSBooleanValue authnRequestSigned;
    @Nullable
    private XSBooleanValue assertionSigned;
    @Nonnull
    private final XMLObjectChildrenList<AssertionConsumerService> assertionConsumerServices = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<AttributeConsumingService> attributeConsumingServices = new XMLObjectChildrenList((XMLObject)this);

    protected SPSSODescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public Boolean isAuthnRequestsSigned() {
        if (this.authnRequestSigned != null) {
            return this.authnRequestSigned.getValue();
        }
        return Boolean.FALSE;
    }

    @Nullable
    public XSBooleanValue isAuthnRequestsSignedXSBoolean() {
        return this.authnRequestSigned;
    }

    public void setAuthnRequestsSigned(@Nullable Boolean newIsSigned) {
        this.authnRequestSigned = newIsSigned != null ? (XSBooleanValue)this.prepareForAssignment(this.authnRequestSigned, new XSBooleanValue(newIsSigned, false)) : (XSBooleanValue)this.prepareForAssignment(this.authnRequestSigned, null);
    }

    public void setAuthnRequestsSigned(@Nullable XSBooleanValue isSigned) {
        this.authnRequestSigned = (XSBooleanValue)this.prepareForAssignment(this.authnRequestSigned, isSigned);
    }

    @Nullable
    public Boolean getWantAssertionsSigned() {
        if (this.assertionSigned != null) {
            return this.assertionSigned.getValue();
        }
        return Boolean.FALSE;
    }

    @Nullable
    public XSBooleanValue getWantAssertionsSignedXSBoolean() {
        return this.assertionSigned;
    }

    public void setWantAssertionsSigned(@Nullable Boolean wantAssestionSigned) {
        this.assertionSigned = wantAssestionSigned != null ? (XSBooleanValue)this.prepareForAssignment(this.assertionSigned, new XSBooleanValue(wantAssestionSigned, false)) : (XSBooleanValue)this.prepareForAssignment(this.assertionSigned, null);
    }

    public void setWantAssertionsSigned(@Nullable XSBooleanValue wantAssestionSigned) {
        this.assertionSigned = (XSBooleanValue)this.prepareForAssignment(this.assertionSigned, wantAssestionSigned);
    }

    @Nonnull
    @Live
    public List<AssertionConsumerService> getAssertionConsumerServices() {
        return this.assertionConsumerServices;
    }

    @Nullable
    public AssertionConsumerService getDefaultAssertionConsumerService() {
        return (AssertionConsumerService)SAML2MetadataSupport.getDefaultIndexedEndpoint(this.assertionConsumerServices);
    }

    @Nonnull
    @Live
    public List<AttributeConsumingService> getAttributeConsumingServices() {
        return this.attributeConsumingServices;
    }

    @Nullable
    public AttributeConsumingService getDefaultAttributeConsumingService() {
        AttributeConsumingServiceSelector selector = new AttributeConsumingServiceSelector();
        selector.setRoleDescriptor((RoleDescriptor)this);
        return selector.selectService();
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints() {
        ArrayList<Object> endpoints = new ArrayList<Object>();
        endpoints.addAll(super.getEndpoints());
        endpoints.addAll((Collection<Object>)this.assertionConsumerServices);
        return CollectionSupport.copyToList(endpoints);
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints(@Nonnull QName type) {
        if (type.equals(AssertionConsumerService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.assertionConsumerServices);
        }
        return super.getEndpoints(type);
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        List<XMLObject> parentChildren = super.getOrderedChildren();
        if (parentChildren != null) {
            children.addAll(parentChildren);
        }
        children.addAll((Collection<Object>)this.assertionConsumerServices);
        children.addAll((Collection<Object>)this.attributeConsumingServices);
        return CollectionSupport.copyToList(children);
    }
}

