/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.internal.ResourceImpl;

final class Util {
    private Util() {
    }

    public static final String zeroPad(String s, int fieldLength) {
        return Util.characterPad(s, fieldLength, '0', false);
    }

    public static final String characterPad(String s, int fieldLength, char padChar, boolean postpend) {
        int sLen = s.length();
        if (sLen < fieldLength) {
            char[] cArr = new char[fieldLength - sLen];
            Arrays.fill(cArr, padChar);
            String addstr = String.valueOf(cArr);
            return postpend ? s.concat(addstr) : addstr.concat(s);
        }
        return s;
    }

    public static String toHexSeparated(Memory mem, int offset, int lengthBytes) {
        int len = (int)Math.min(mem.getCapacity(), (long)lengthBytes);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b = mem.getByte(offset + i);
            sb.append(Util.zeroPad(Integer.toString(b), 2));
            sb.append(" ");
        }
        return sb.toString();
    }

    static final boolean isAllBitsClear(long value, long bitMask) {
        return ((value ^ 0xFFFFFFFFFFFFFFFFL) & bitMask) == bitMask;
    }

    static final boolean isAllBitsSet(long value, long bitMask) {
        return (value & bitMask) == bitMask;
    }

    static final boolean isAnyBitsClear(long value, long bitMask) {
        return ((value ^ 0xFFFFFFFFFFFFFFFFL) & bitMask) != 0L;
    }

    static final boolean isAnyBitsSet(long value, long bitMask) {
        return (value & bitMask) != 0L;
    }

    private static String getResourcePath(String shortFileName) {
        Objects.requireNonNull(shortFileName, "input parameter " + shortFileName + " cannot be null.");
        try {
            URL url = Util.class.getClassLoader().getResource(shortFileName);
            Objects.requireNonNull(url, "resource " + shortFileName + " could not be acquired.");
            URI uri = url.toURI();
            String path = uri.isAbsolute() ? Paths.get(uri).toAbsolutePath().toString() : uri.getPath();
            return path;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot find resource: " + shortFileName + ResourceImpl.LS + String.valueOf(e));
        }
    }

    static File getResourceFile(String shortFileName) {
        return new File(Util.getResourcePath(shortFileName));
    }
}

