/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.queue;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.apache.flink.agents.runtime.queue.Lock;
import org.apache.flink.annotation.Internal;

@Internal
public final class MpscQueue<T> {
    private static final Deque<?> EMPTY = new ArrayDeque(0);
    private final Lock lock;
    private ArrayDeque<T> active;
    private ArrayDeque<T> standby;

    public MpscQueue(int initialBufferSize, Lock lock) {
        this.lock = Objects.requireNonNull(lock);
        this.active = new ArrayDeque(initialBufferSize);
        this.standby = new ArrayDeque(initialBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(T element) {
        Objects.requireNonNull(element);
        Lock lock = this.lock;
        lock.lockUninterruptibly();
        try {
            ArrayDeque<T> active = this.active;
            active.addLast(element);
            int n = active.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deque<T> drainAll() {
        Lock lock = this.lock;
        lock.lockUninterruptibly();
        try {
            ArrayDeque<T> ready = this.active;
            if (ready.isEmpty()) {
                Deque<T> deque = MpscQueue.empty();
                return deque;
            }
            this.active = this.standby;
            this.standby = ready;
            ArrayDeque<T> arrayDeque = ready;
            return arrayDeque;
        }
        finally {
            lock.unlock();
        }
    }

    private static <T> Deque<T> empty() {
        return EMPTY;
    }
}

