/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;

public class DirectoryView<ObjectType extends Identifiable>
implements Directory<ObjectType> {
    private final Directory<ObjectType> directory;
    private final Set<String> identifiers;

    public DirectoryView(Directory<ObjectType> directory, Set<String> identifiers) {
        this.directory = directory;
        this.identifiers = identifiers;
    }

    public ObjectType get(String identifier) throws GuacamoleException {
        if (!this.identifiers.contains(identifier)) {
            return null;
        }
        return (ObjectType)this.directory.get(identifier);
    }

    public Collection<ObjectType> getAll(Collection<String> identifiers) throws GuacamoleException {
        identifiers = new ArrayList<String>(identifiers);
        identifiers.retainAll(this.identifiers);
        return this.directory.getAll(identifiers);
    }

    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.identifiers;
    }

    public void add(ObjectType object) throws GuacamoleException {
        throw new GuacamoleUnsupportedException("Directory view is read-only");
    }

    public void update(ObjectType object) throws GuacamoleException {
        throw new GuacamoleUnsupportedException("Directory view is read-only");
    }

    public void remove(String identifier) throws GuacamoleException {
        throw new GuacamoleUnsupportedException("Directory view is read-only");
    }
}

