/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.IFSCachedAttributes;
import com.ibm.as400.access.IFSFileImpl;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ProxyClientConnection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class IFSFileImplProxy
extends AbstractProxyImpl
implements IFSFileImpl {
    IFSFileImplProxy() {
        super("IFSFile");
    }

    @Override
    public boolean canExecute() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "canExecute");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public boolean canRead() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "canRead");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public boolean canWrite() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "canWrite");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public void clearCachedAttributes() {
        try {
            this.connection_.callMethod(this.pxId_, "clearCachedAttributes");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public boolean copyTo(String path, boolean replace) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        try {
            return (Boolean)this.connection_.callMethod(this.pxId_, "copyTo", new Class[]{String.class, Boolean.TYPE}, new Object[]{path, replace}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow3a(e);
        }
    }

    @Override
    public long created() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "created").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int createNewFile() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "createNewFile");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int delete() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "delete");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int exists() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "exists");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int getCCSID(boolean retrieveAll) throws IOException, AS400SecurityException {
        return this.getCCSID();
    }

    @Override
    public int getCCSID() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "getCCSID");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public long getAvailableSpace(boolean forUserOnly) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "getAvailableSpace", new Class[]{Boolean.TYPE}, new Object[]{forUserOnly}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public long getTotalSpace(boolean forUserOnly) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "getTotalSpace", new Class[]{Boolean.TYPE}, new Object[]{forUserOnly}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public String getOwnerName(boolean retrieveAll) throws IOException, AS400SecurityException {
        return this.getOwnerName();
    }

    @Override
    public String getOwnerName() throws IOException, AS400SecurityException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "getOwnerName").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public String getOwnerNameByUserHandle(boolean forceRetrieve) throws IOException, AS400SecurityException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "getOwnerNameByUserHandle").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public int getASP() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "getASP").getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public String getFileSystemType() throws IOException, AS400SecurityException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "getFileSystemType").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public long getOwnerUID() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "getOwnerUID").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public String getPathPointedTo() throws IOException, AS400SecurityException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "getPathPointedTo").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public String getSubtype() throws IOException, AS400SecurityException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "getSubtype").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public int isDirectory() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "isDirectory");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int isFile() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "isFile");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public boolean isHidden() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "isHidden");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public boolean isReadOnly() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "isReadOnly");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public boolean isSourcePhysicalFile() throws IOException, AS400SecurityException, AS400Exception {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "isSymbolicLink");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow3(e);
        }
    }

    @Override
    public boolean isSymbolicLink() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "isSymbolicLink");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public long lastAccessed() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "lastAccessed").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public long lastModified() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "lastModified").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public long length() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "length").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public String[] listDirectoryContents(String directoryPath) throws IOException, AS400SecurityException {
        try {
            return (String[])this.connection_.callMethod(this.pxId_, "listDirectoryContents", new Class[]{String.class}, new Object[]{directoryPath}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public IFSCachedAttributes[] listDirectoryDetails(String directoryPattern, String directoryPath, int maxGetCount, String restartName) throws IOException, AS400SecurityException {
        try {
            return (IFSCachedAttributes[])this.connection_.callMethod(this.pxId_, "listDirectoryDetails", new Class[]{String.class, String.class, Integer.TYPE, String.class}, new Object[]{directoryPattern, directoryPath, maxGetCount, restartName}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public IFSCachedAttributes[] listDirectoryDetails(String directoryPattern, String directoryPath, int maxGetCount, byte[] restartID, boolean allowSortedRequests) throws IOException, AS400SecurityException {
        try {
            return (IFSCachedAttributes[])this.connection_.callMethod(this.pxId_, "listDirectoryDetails", new Class[]{String.class, String.class, Integer.TYPE, byte[].class, Boolean.TYPE}, new Object[]{directoryPattern, directoryPath, maxGetCount, restartID, allowSortedRequests}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int mkdir(String directory) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "mkdir", new Class[]{String.class}, new Object[]{directory}).getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int mkdirs() throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "mkdirs");
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    @Override
    public int renameTo(IFSFileImpl file) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "renameTo", new Class[]{IFSFileImpl.class}, new Object[]{file}).getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw IFSFileImplProxy.rethrow2(e);
        }
    }

    private static InternalErrorException rethrow2(InvocationTargetException e) throws IOException, AS400SecurityException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof IOException) {
            throw (IOException)e2;
        }
        if (e2 instanceof AS400SecurityException) {
            throw (AS400SecurityException)e2;
        }
        return ProxyClientConnection.rethrow(e);
    }

    private static InternalErrorException rethrow3(InvocationTargetException e) throws IOException, AS400SecurityException, AS400Exception {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof IOException) {
            throw (IOException)e2;
        }
        if (e2 instanceof AS400SecurityException) {
            throw (AS400SecurityException)e2;
        }
        if (e2 instanceof AS400Exception) {
            throw (AS400Exception)e2;
        }
        return ProxyClientConnection.rethrow(e);
    }

    private static InternalErrorException rethrow3a(InvocationTargetException e) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof IOException) {
            throw (IOException)e2;
        }
        if (e2 instanceof AS400SecurityException) {
            throw (AS400SecurityException)e2;
        }
        if (e2 instanceof ObjectAlreadyExistsException) {
            throw (ObjectAlreadyExistsException)e2;
        }
        return ProxyClientConnection.rethrow(e);
    }

    @Override
    public boolean setAccess(int accessType, boolean enableAccess, boolean ownerOnly) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "setAccess", new Class[]{Integer.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{accessType, enableAccess, ownerOnly}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public boolean setCCSID(int ccsid) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "setCCSID", new Class[]{Integer.TYPE}, new Object[]{ccsid}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public boolean setFixedAttributes(int attributes) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "setFixedAttributes", new Class[]{Integer.TYPE}, new Object[]{attributes}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public boolean setHidden(boolean attribute) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "setHidden", new Class[]{Boolean.TYPE}, new Object[]{attribute}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public boolean setLastModified(long time) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "setLastModified", new Class[]{Long.TYPE}, new Object[]{time}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public boolean setLength(int length) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "setLength", new Class[]{Integer.TYPE}, new Object[]{length}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public void setPatternMatching(int patternMatching) {
        try {
            this.connection_.callMethod(this.pxId_, "setPatternMatching", new Class[]{Integer.TYPE}, new Object[]{patternMatching});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public boolean setReadOnly(boolean attribute) throws IOException, AS400SecurityException {
        try {
            return this.connection_.callMethod(this.pxId_, "setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{attribute}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public void setPath(String path) {
        try {
            this.connection_.callMethod(this.pxId_, "setPath", new Class[]{String.class}, new Object[]{path});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setSorted(boolean sort) {
        try {
            this.connection_.callMethod(this.pxId_, "setSorted", new Class[]{Boolean.TYPE}, new Object[]{sort});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setSystem(AS400Impl system) {
        try {
            this.connection_.callMethod(this.pxId_, "setSystem", new Class[]{AS400Impl.class}, new Object[]{system});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public String getDescription() throws AS400SecurityException, IOException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "getDescription").getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }
}

