/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoRequestCoordinator;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoStats;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoTracker;
import org.apache.flink.shaded.guava31.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.Preconditions;

public class VertexThreadInfoTrackerBuilder {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;
    private final ScheduledExecutorService executor;
    private final Time restTimeout;
    private ThreadInfoRequestCoordinator coordinator;
    private Duration cleanUpInterval;
    private int numSamples;
    private Duration statsRefreshInterval;
    private Duration delayBetweenSamples;
    private int maxThreadInfoDepth;
    private Cache<VertexThreadInfoTracker.JobVertexKey, VertexThreadInfoStats> jobVertexStatsCache;
    private Cache<VertexThreadInfoTracker.ExecutionVertexKey, VertexThreadInfoStats> executionVertexStatsCache;

    VertexThreadInfoTrackerBuilder(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, ScheduledExecutorService executor, Time restTimeout) {
        this.resourceManagerGatewayRetriever = resourceManagerGatewayRetriever;
        this.executor = executor;
        this.restTimeout = restTimeout;
    }

    public VertexThreadInfoTrackerBuilder setCoordinator(ThreadInfoRequestCoordinator coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    public VertexThreadInfoTrackerBuilder setCleanUpInterval(Duration cleanUpInterval) {
        this.cleanUpInterval = cleanUpInterval;
        return this;
    }

    public VertexThreadInfoTrackerBuilder setNumSamples(int numSamples) {
        this.numSamples = numSamples;
        return this;
    }

    public VertexThreadInfoTrackerBuilder setStatsRefreshInterval(Duration statsRefreshInterval) {
        this.statsRefreshInterval = statsRefreshInterval;
        return this;
    }

    public VertexThreadInfoTrackerBuilder setDelayBetweenSamples(Duration delayBetweenSamples) {
        this.delayBetweenSamples = delayBetweenSamples;
        return this;
    }

    public VertexThreadInfoTrackerBuilder setMaxThreadInfoDepth(int maxThreadInfoDepth) {
        this.maxThreadInfoDepth = maxThreadInfoDepth;
        return this;
    }

    @VisibleForTesting
    VertexThreadInfoTrackerBuilder setJobVertexStatsCache(Cache<VertexThreadInfoTracker.JobVertexKey, VertexThreadInfoStats> jobVertexStatsCache) {
        this.jobVertexStatsCache = jobVertexStatsCache;
        return this;
    }

    @VisibleForTesting
    VertexThreadInfoTrackerBuilder setExecutionVertexStatsCache(Cache<VertexThreadInfoTracker.ExecutionVertexKey, VertexThreadInfoStats> executionVertexStatsCache) {
        this.executionVertexStatsCache = executionVertexStatsCache;
        return this;
    }

    public VertexThreadInfoTracker build() {
        if (this.jobVertexStatsCache == null) {
            this.jobVertexStatsCache = this.defaultCache();
        }
        if (this.executionVertexStatsCache == null) {
            this.executionVertexStatsCache = this.defaultCache();
        }
        return new VertexThreadInfoTracker(this.coordinator, this.resourceManagerGatewayRetriever, this.executor, this.cleanUpInterval, this.numSamples, this.statsRefreshInterval, this.delayBetweenSamples, this.maxThreadInfoDepth, this.restTimeout, this.jobVertexStatsCache, this.executionVertexStatsCache);
    }

    private <K> Cache<K, VertexThreadInfoStats> defaultCache() {
        Preconditions.checkArgument((this.cleanUpInterval.toMillis() > 0L ? 1 : 0) != 0, (Object)"Clean up interval must be greater than 0");
        return CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(this.cleanUpInterval.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static VertexThreadInfoTrackerBuilder newBuilder(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, ScheduledExecutorService executor, Time restTimeout) {
        return new VertexThreadInfoTrackerBuilder(resourceManagerGatewayRetriever, executor, restTimeout);
    }
}

