/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.movefiles;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="MOVE_FILES", name="i18n::ActionMoveFiles.Name", description="i18n::ActionMoveFiles.Description", image="MoveFiles.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionMoveFiles.keyword"}, documentationUrl="/workflow/actions/movefiles.html")
public class ActionMoveFiles
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionMoveFiles.class;
    public static final String CONST_SPACES_LONG = "          ";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_DO_NOTHING = "do_nothing";
    public static final String CONST_ACTION_MOVE_FILES_ERROR_GETTING_FILENAME = "ActionMoveFiles.Error.GettingFilename";
    public static final String CONST_ACTION_MOVE_FILES_LOG_FILE_MOVED = "ActionMoveFiles.Log.FileMoved";
    public static final String CONST_ACTION_MOVE_FILES_ERROR_SUCCESS_CONDITIONBROKEN = "ActionMoveFiles.Error.SuccessConditionbroken";
    public boolean moveEmptyFolders = true;
    public boolean argFromPrevious = false;
    public boolean includeSubfolders = false;
    public boolean addResultFilenames = false;
    public boolean destinationIsAFile = false;
    public boolean createDestinationFolder = false;
    public String[] sourceFileFolder = null;
    public String[] destinationFileFolder = null;
    public String[] wildcard = null;
    private String nrErrorsLessThan = "10";
    private String successCondition = "success_if_no_errors";
    public static final String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public static final String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public static final String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private boolean addDate = false;
    private boolean addTime = false;
    private boolean specifyFormat = false;
    private String dateTimeFormat = null;
    private boolean addDateBeforeExtension = false;
    private boolean doNotKeepFolderStructure = false;
    private String ifFileExists = "do_nothing";
    private String destinationFolder = null;
    private String ifMovedFileExists = "do_nothing";
    private String movedDateTimeFormat = null;
    private boolean addMovedDateBeforeExtension = false;
    private boolean addMovedDate = false;
    private boolean addMovedTime = false;
    private boolean specifyMoveFormat = false;
    public boolean createMoveToFolder = false;
    public boolean simulate = false;
    int nrErrors = 0;
    int nrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;

    public ActionMoveFiles(String n) {
        super(n, "");
    }

    public ActionMoveFiles() {
        this("");
    }

    public void allocate(int nrFields) {
        this.sourceFileFolder = new String[nrFields];
        this.destinationFileFolder = new String[nrFields];
        this.wildcard = new String[nrFields];
    }

    public Object clone() {
        ActionMoveFiles je = (ActionMoveFiles)super.clone();
        if (this.sourceFileFolder != null) {
            int nrFields = this.sourceFileFolder.length;
            je.allocate(nrFields);
            System.arraycopy(this.sourceFileFolder, 0, je.sourceFileFolder, 0, nrFields);
            System.arraycopy(this.wildcard, 0, je.wildcard, 0, nrFields);
            System.arraycopy(this.destinationFileFolder, 0, je.destinationFileFolder, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(600);
        retval.append(super.getXml());
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"move_empty_folders", (boolean)this.moveEmptyFolders));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_result_filesname", (boolean)this.addResultFilenames));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destinationIsAFile));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"create_destination_folder", (boolean)this.createDestinationFolder));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyFormat));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"nr_errors_less_than", (String)this.nrErrorsLessThan));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"success_condition", (String)this.successCondition));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.addDateBeforeExtension));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"DoNotKeepFolderStructure", (boolean)this.doNotKeepFolderStructure));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"iffileexists", (String)this.ifFileExists));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"destinationFolder", (String)this.destinationFolder));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"ifmovedfileexists", (String)this.ifMovedFileExists));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"moved_date_time_format", (String)this.movedDateTimeFormat));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"create_move_to_folder", (boolean)this.createMoveToFolder));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_moved_date", (boolean)this.addMovedDate));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_moved_time", (boolean)this.addMovedTime));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"SpecifyMoveFormat", (boolean)this.specifyMoveFormat));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"AddMovedDateBeforeExtension", (boolean)this.addMovedDateBeforeExtension));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"simulate", (boolean)this.simulate));
        retval.append("      <fields>").append(Const.CR);
        if (this.sourceFileFolder != null) {
            for (int i = 0; i < this.sourceFileFolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"source_filefolder", (String)this.sourceFileFolder[i]));
                retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"destination_filefolder", (String)this.destinationFileFolder[i]));
                retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.moveEmptyFolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"move_empty_folders"));
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.addResultFilenames = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destinationIsAFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.createDestinationFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            this.addDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.specifyFormat = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.addDateBeforeExtension = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            this.doNotKeepFolderStructure = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"DoNotKeepFolderStructure"));
            this.dateTimeFormat = XmlHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.nrErrorsLessThan = XmlHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.successCondition = XmlHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.ifFileExists = XmlHandler.getTagValue((Node)entrynode, (String)"iffileexists");
            this.destinationFolder = XmlHandler.getTagValue((Node)entrynode, (String)"destinationFolder");
            this.ifMovedFileExists = XmlHandler.getTagValue((Node)entrynode, (String)"ifmovedfileexists");
            this.movedDateTimeFormat = XmlHandler.getTagValue((Node)entrynode, (String)"moved_date_time_format");
            this.addMovedDateBeforeExtension = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"AddMovedDateBeforeExtension"));
            this.createMoveToFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"create_move_to_folder"));
            this.addMovedDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_moved_date"));
            this.addMovedTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_moved_time"));
            this.specifyMoveFormat = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"SpecifyMoveFormat"));
            this.simulate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"simulate"));
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceFileFolder[i] = XmlHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.destinationFileFolder[i] = XmlHandler.getTagValue((Node)fnode, (String)"destination_filefolder");
                this.wildcard[i] = XmlHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) throws HopException {
        String[] vwildcard;
        String[] vDestinationFileFolder;
        String[] vSourceFileFolder;
        String moveToFolder;
        RowMetaAndData resultRow;
        List rows;
        Result result;
        block41: {
            result = previousResult;
            rows = result.getRows();
            resultRow = null;
            result.setNrErrors(1L);
            result.setResult(false);
            this.nrErrors = 0;
            this.nrSuccess = 0;
            this.successConditionBroken = false;
            this.successConditionBrokenExit = false;
            this.limitFiles = Const.toInt((String)this.resolve(this.getNrErrorsLessThan()), (int)10);
            if (this.isDetailed()) {
                if (this.simulate) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.SimulationOn", (String[])new String[0]));
                }
                if (this.includeSubfolders) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.IncludeSubFoldersOn", (String[])new String[0]));
                }
            }
            moveToFolder = this.resolve(this.destinationFolder);
            vSourceFileFolder = this.sourceFileFolder;
            vDestinationFileFolder = this.destinationFileFolder;
            vwildcard = this.wildcard;
            if (this.ifFileExists.equals("move_file")) {
                Result result2;
                if (Utils.isEmpty((CharSequence)moveToFolder)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Error.MoveToFolderMissing", (String[])new String[0]));
                    return result;
                }
                FileObject folder = null;
                try {
                    folder = HopVfs.getFileObject((String)moveToFolder, (IVariables)this.getVariables());
                    if (!folder.exists()) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Error.FolderMissing", (String[])new String[]{moveToFolder}));
                        }
                        if (this.createMoveToFolder) {
                            folder.createFolder();
                        } else {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Error.FolderMissing", (String[])new String[]{moveToFolder}));
                            Result result3 = result;
                            return result3;
                        }
                    }
                    if (folder.getType().equals((Object)FileType.FOLDER)) break block41;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Error.NotFolder", (String[])new String[]{moveToFolder}));
                    result2 = result;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Error.GettingMoveToFolder", (String[])new String[]{moveToFolder, e.getMessage()}));
                    Result result4 = result;
                    return result4;
                }
                finally {
                    if (folder != null) {
                        try {
                            folder.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return result2;
            }
        }
        if (this.argFromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setNrErrors((long)this.nrErrors);
                    this.displayResults();
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                String vSourceFileFolderPrevious = resultRow.getString(0, null);
                String vDestinationFileFolderPrevious = resultRow.getString(1, null);
                String vWildcardPrevious = resultRow.getString(2, null);
                if (!Utils.isEmpty((CharSequence)vSourceFileFolderPrevious) && !Utils.isEmpty((CharSequence)vDestinationFileFolderPrevious)) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.ProcessingRow", (String[])new String[]{vSourceFileFolderPrevious, vDestinationFileFolderPrevious, vWildcardPrevious}));
                    }
                    if (this.processFileFolder(vSourceFileFolderPrevious, vDestinationFileFolderPrevious, vWildcardPrevious, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result, moveToFolder)) continue;
                    this.updateErrors();
                    continue;
                }
                if (!this.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.IgnoringRow", (String[])new String[]{vSourceFileFolder[iteration], vDestinationFileFolder[iteration], vwildcard[iteration]}));
            }
        } else if (vSourceFileFolder != null && vDestinationFileFolder != null) {
            for (int i = 0; i < vSourceFileFolder.length && !this.parentWorkflow.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setNrErrors((long)this.nrErrors);
                    this.displayResults();
                    return result;
                }
                if (!Utils.isEmpty((CharSequence)vSourceFileFolder[i]) && !Utils.isEmpty((CharSequence)vDestinationFileFolder[i])) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.ProcessingRow", (String[])new String[]{vSourceFileFolder[i], vDestinationFileFolder[i], vwildcard[i]}));
                    }
                    if (this.processFileFolder(vSourceFileFolder[i], vDestinationFileFolder[i], vwildcard[i], (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result, moveToFolder)) continue;
                    this.updateErrors();
                    continue;
                }
                if (!this.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.IgnoringRow", (String[])new String[]{vSourceFileFolder[i], vDestinationFileFolder[i], vwildcard[i]}));
            }
        }
        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesWritten((long)this.nrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Info.FilesInError", (String[])new String[]{"" + this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Info.FilesInSuccess", (String[])new String[]{"" + this.nrSuccess}));
            this.logDetailed("=======================================");
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.nrErrors == 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrSuccess >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.nrErrors <= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processFileFolder(String sourcefilefoldername, String destinationfilefoldername, String wildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result, String moveToFolder) {
        int j;
        FileObject[] fileObjects;
        String realWildcard;
        String realDestinationFilefoldername;
        FileObject currentfile;
        FileObject movetofolderfolder;
        FileObject sourcefilefolder;
        block100: {
            boolean entrystatus = false;
            sourcefilefolder = null;
            FileObject destinationfilefolder = null;
            movetofolderfolder = null;
            currentfile = null;
            String realSourceFilefoldername = this.resolve(sourcefilefoldername);
            realDestinationFilefoldername = this.resolve(destinationfilefoldername);
            realWildcard = this.resolve(wildcard);
            try {
                sourcefilefolder = HopVfs.getFileObject((String)realSourceFilefoldername, (IVariables)this.getVariables());
                destinationfilefolder = HopVfs.getFileObject((String)realDestinationFilefoldername, (IVariables)this.getVariables());
                if (!Utils.isEmpty((CharSequence)moveToFolder)) {
                    movetofolderfolder = HopVfs.getFileObject((String)moveToFolder, (IVariables)this.getVariables());
                }
                if (sourcefilefolder.exists()) {
                    if (!this.createDestinationFolder(destinationfilefolder)) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Error.DestinationFolderNotFound", (String[])new String[]{realDestinationFilefoldername}));
                        return entrystatus;
                    }
                    if (sourcefilefolder.getType().equals((Object)FileType.FOLDER) && this.destinationIsAFile) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Forbidden", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.CanNotMoveFolderToFile", (String[])new String[]{realSourceFilefoldername, realDestinationFilefoldername})});
                        this.updateErrors();
                        return true;
                    }
                    if (destinationfilefolder.getType().equals((Object)FileType.FOLDER) && sourcefilefolder.getType().equals((Object)FileType.FILE)) {
                        String shortfilename = sourcefilefolder.getName().getBaseName();
                        try {
                            shortfilename = this.getDestinationFilename(shortfilename);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_GETTING_FILENAME, (String[])new String[]{sourcefilefolder.getName().getBaseName(), e.toString()}), (String[])new String[0]));
                            boolean bl = entrystatus;
                            if (sourcefilefolder != null) {
                                try {
                                    sourcefilefolder.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (destinationfilefolder != null) {
                                try {
                                    destinationfilefolder.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (currentfile != null) {
                                try {
                                    currentfile.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (movetofolderfolder == null) return bl;
                            try {
                                movetofolderfolder.close();
                                return bl;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return bl;
                        }
                        String destinationfilenamefull = HopVfs.getFilename((FileObject)destinationfilefolder) + Const.FILE_SEPARATOR + shortfilename;
                        FileObject destinationfile = HopVfs.getFileObject((String)destinationfilenamefull, (IVariables)this.getVariables());
                        destinationfile.createFolder();
                        boolean bl = entrystatus = this.moveFile(shortfilename, sourcefilefolder, destinationfile, movetofolderfolder, parentWorkflow, result);
                        return bl;
                    }
                    if (sourcefilefolder.getType().equals((Object)FileType.FILE) && this.destinationIsAFile) {
                        FileObject destinationfile = HopVfs.getFileObject((String)realDestinationFilefoldername, (IVariables)this.getVariables());
                        String shortfilename = destinationfile.getName().getBaseName();
                        try {
                            shortfilename = this.getDestinationFilename(shortfilename);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_GETTING_FILENAME, (String[])new String[]{sourcefilefolder.getName().getBaseName(), e.toString()}), (String[])new String[0]));
                            boolean bl = entrystatus;
                            if (sourcefilefolder != null) {
                                try {
                                    sourcefilefolder.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (destinationfilefolder != null) {
                                try {
                                    destinationfilefolder.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (currentfile != null) {
                                try {
                                    currentfile.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (movetofolderfolder == null) return bl;
                            try {
                                movetofolderfolder.close();
                                return bl;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return bl;
                        }
                        if (destinationfile.getName().getURI().startsWith("azfs")) {
                            destinationfile = HopVfs.getFileObject((String)destinationfilefoldername, (IVariables)this.getVariables());
                        } else {
                            String destinationfilenamefull = HopVfs.getFilename((FileObject)destinationfile.getParent()) + Const.FILE_SEPARATOR + shortfilename;
                            destinationfile = HopVfs.getFileObject((String)destinationfilenamefull, (IVariables)this.getVariables());
                        }
                        boolean bl = entrystatus = this.moveFile(shortfilename, sourcefilefolder, destinationfile, movetofolderfolder, parentWorkflow, result);
                        return bl;
                    }
                    if (this.isDetailed()) {
                        this.logDetailed("  ");
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FetchFolder", (String[])new String[]{sourcefilefolder.toString()}));
                    }
                    if ((fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                        public boolean traverseDescendents(FileSelectInfo info) {
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean includeFile(FileSelectInfo info) {
                            FileObject fileObject = info.getFile();
                            try {
                                if (fileObject == null) {
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            catch (Exception ex) {
                                boolean bl = false;
                                return bl;
                            }
                            finally {
                                if (fileObject != null) {
                                    try {
                                        fileObject.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                            return true;
                        }
                    })) == null) return true;
                    j = 0;
                    break block100;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                return entrystatus;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Error.Exception.MoveProcess", (String[])new String[]{realSourceFilefoldername, destinationfilefolder.toString(), e.getMessage()}));
                return entrystatus;
            }
            finally {
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException iOException) {}
                }
                if (destinationfilefolder != null) {
                    try {
                        destinationfilefolder.close();
                    }
                    catch (IOException iOException) {}
                }
                if (currentfile != null) {
                    try {
                        currentfile.close();
                    }
                    catch (IOException iOException) {}
                }
                if (movetofolderfolder != null) {
                    try {
                        movetofolderfolder.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        while (j < fileObjects.length) {
            if (parentWorkflow.isStopped()) return true;
            if (this.successConditionBroken) {
                if (this.successConditionBrokenExit) return false;
                this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_SUCCESS_CONDITIONBROKEN, (String[])new String[]{"" + this.nrErrors}));
                this.successConditionBrokenExit = true;
                return false;
            }
            currentfile = fileObjects[j];
            if (!this.moveOneFile(currentfile, sourcefilefolder, realDestinationFilefoldername, realWildcard, parentWorkflow, result, movetofolderfolder)) {
                this.updateErrors();
            }
            ++j;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveFile(String shortfilename, FileObject sourcefilename, FileObject destinationfilename, FileObject movetofolderfolder, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result) {
        boolean retval;
        block59: {
            FileObject destinationfile = null;
            retval = false;
            try {
                Object shortFilename;
                if (!destinationfilename.exists()) {
                    FileObject destinationFilePath;
                    if (this.includeSubfolders && !(destinationFilePath = HopVfs.getFileObject((String)destinationfilename.getName().getParent().toString(), (IVariables)this.getVariables())).exists()) {
                        destinationFilePath.createFolder();
                    }
                    if (!this.simulate) {
                        destinationfilename.createFile();
                        sourcefilename.moveTo(destinationfilename);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_LOG_FILE_MOVED, (String[])new String[]{sourcefilename.getName().toString(), destinationfilename.getName().toString()}));
                    }
                    if (this.addResultFilenames && !this.ifFileExists.equals("fail") && !this.ifFileExists.equals(CONST_DO_NOTHING)) {
                        this.addFileToResultFilenames(destinationfilename.toString(), result, parentWorkflow);
                    }
                    this.updateSuccess();
                    retval = true;
                    break block59;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FileExists", (String[])new String[]{destinationfilename.toString()}));
                }
                if (this.ifFileExists.equals("overwrite_file")) {
                    if (!this.simulate) {
                        sourcefilename.moveTo(destinationfilename);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FileOverwrite", (String[])new String[]{destinationfilename.getName().toString()}));
                    }
                    if (this.addResultFilenames && !this.ifFileExists.equals("fail") && !this.ifFileExists.equals(CONST_DO_NOTHING)) {
                        this.addFileToResultFilenames(destinationfilename.toString(), result, parentWorkflow);
                    }
                    this.updateSuccess();
                    retval = true;
                    break block59;
                }
                if (this.ifFileExists.equals("unique_name")) {
                    shortFilename = shortfilename;
                    try {
                        shortFilename = this.getMoveDestinationFilename((String)shortFilename, "ddMMyyyy_HHmmssSSS");
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_GETTING_FILENAME, (String[])new String[]{shortFilename}), (String[])new String[0]), e);
                        boolean bl = retval;
                        if (destinationfile != null) {
                            try {
                                destinationfile.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    String movetofilenamefull = destinationfilename.getParent().toString() + Const.FILE_SEPARATOR + (String)shortFilename;
                    destinationfile = HopVfs.getFileObject((String)movetofilenamefull, (IVariables)this.getVariables());
                    if (!this.simulate) {
                        sourcefilename.moveTo(destinationfile);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_LOG_FILE_MOVED, (String[])new String[]{sourcefilename.getName().toString(), destinationfile.getName().toString()}));
                    }
                    if (this.addResultFilenames && !this.ifFileExists.equals("fail") && !this.ifFileExists.equals(CONST_DO_NOTHING)) {
                        this.addFileToResultFilenames(destinationfile.toString(), result, parentWorkflow);
                    }
                    this.updateSuccess();
                    retval = true;
                    break block59;
                }
                if (this.ifFileExists.equals("delete_file")) {
                    if (!this.simulate) {
                        sourcefilename.delete();
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FileDeleted", (String[])new String[]{destinationfilename.getName().toString()}));
                    }
                    this.updateSuccess();
                    retval = true;
                    break block59;
                }
                if (this.ifFileExists.equals("move_file")) {
                    shortFilename = shortfilename;
                    try {
                        shortFilename = this.getMoveDestinationFilename((String)shortFilename, null);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_GETTING_FILENAME, (String[])new String[]{shortFilename}), (String[])new String[0]), e);
                        boolean bl = retval;
                        if (destinationfile != null) {
                            try {
                                destinationfile.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    String movetofilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + (String)shortFilename;
                    destinationfile = HopVfs.getFileObject((String)movetofilenamefull, (IVariables)this.getVariables());
                    if (!destinationfile.exists()) {
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_LOG_FILE_MOVED, (String[])new String[]{sourcefilename.getName().toString(), destinationfile.getName().toString()}));
                        }
                        if (this.addResultFilenames && !this.ifFileExists.equals("fail") && !this.ifFileExists.equals(CONST_DO_NOTHING)) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentWorkflow);
                        }
                    } else if (this.ifMovedFileExists.equals("overwrite_file")) {
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FileOverwrite", (String[])new String[]{destinationfile.getName().toString()}));
                        }
                        if (this.addResultFilenames && !this.ifFileExists.equals("fail") && !this.ifFileExists.equals(CONST_DO_NOTHING)) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentWorkflow);
                        }
                        this.updateSuccess();
                        retval = true;
                    } else if (this.ifMovedFileExists.equals("unique_name")) {
                        SimpleDateFormat daf = new SimpleDateFormat();
                        Date now = new Date();
                        daf.applyPattern("ddMMyyyy_HHmmssSSS");
                        String dt = daf.format(now);
                        shortFilename = (String)shortFilename + "_" + dt;
                        String destinationfilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + (String)shortFilename;
                        destinationfile = HopVfs.getFileObject((String)destinationfilenamefull, (IVariables)this.getVariables());
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_LOG_FILE_MOVED, (String[])new String[]{destinationfile.getName().toString()}));
                        }
                        if (this.addResultFilenames && !this.ifFileExists.equals("fail") && !this.ifFileExists.equals(CONST_DO_NOTHING)) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentWorkflow);
                        }
                        this.updateSuccess();
                        retval = true;
                    } else if (this.ifMovedFileExists.equals("fail")) {
                        this.updateErrors();
                    }
                    break block59;
                }
                if (this.ifFileExists.equals("fail")) {
                    this.updateErrors();
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Error.Exception.MoveProcessError", (String[])new String[]{sourcefilename.toString(), destinationfilename.toString(), e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()}));
                this.updateErrors();
            }
            finally {
                if (destinationfile != null) {
                    try {
                        destinationfile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveOneFile(FileObject currentfile, FileObject sourcefilefolder, String realDestinationFilefoldername, String realWildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result, FileObject movetofolderfolder) {
        boolean entrystatus = false;
        FileObject filename = null;
        try {
            if (!currentfile.toString().equals(sourcefilefolder.toString())) {
                String sourceshortfilename;
                String shortfilename = sourceshortfilename = currentfile.getName().getBaseName();
                try {
                    shortfilename = this.getDestinationFilename(sourceshortfilename);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)BaseMessages.getString(PKG, (String)CONST_ACTION_MOVE_FILES_ERROR_GETTING_FILENAME, (String[])new String[]{currentfile.getName().getBaseName(), e.toString()}), (String[])new String[0]));
                    boolean bl = entrystatus;
                    if (filename != null) {
                        try {
                            filename.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                int lenCurrent = sourceshortfilename.length();
                Object shortFilenameFromBaseFolder = shortfilename;
                if (!this.isDoNotKeepFolderStructure()) {
                    shortFilenameFromBaseFolder = currentfile.toString().substring(sourcefilefolder.toString().length(), currentfile.toString().length());
                }
                shortFilenameFromBaseFolder = ((String)shortFilenameFromBaseFolder).substring(0, ((String)shortFilenameFromBaseFolder).length() - lenCurrent) + shortfilename;
                filename = HopVfs.getFileObject((String)(realDestinationFilefoldername + Const.FILE_SEPARATOR + (String)shortFilenameFromBaseFolder), (IVariables)this.getVariables());
                if (!currentfile.getParent().toString().equals(sourcefilefolder.toString())) {
                    if (this.includeSubfolders) {
                        if (currentfile.getType() == FileType.FOLDER) {
                            if (this.includeSubfolders && this.moveEmptyFolders && Utils.isEmpty((CharSequence[])this.wildcard)) {
                                entrystatus = this.moveFile(shortfilename, currentfile, filename, movetofolderfolder, parentWorkflow, result);
                            }
                        } else if (this.getFileWildcard(sourceshortfilename, realWildcard)) {
                            entrystatus = this.moveFile(shortfilename, currentfile, filename, movetofolderfolder, parentWorkflow, result);
                        }
                    }
                } else if (currentfile.getType() == FileType.FOLDER) {
                    if (this.includeSubfolders && this.moveEmptyFolders && Utils.isEmpty((CharSequence[])this.wildcard)) {
                        entrystatus = this.moveFile(shortfilename, currentfile, filename, movetofolderfolder, parentWorkflow, result);
                    }
                } else if (this.getFileWildcard(sourceshortfilename, realWildcard)) {
                    entrystatus = this.moveFile(shortfilename, currentfile, filename, movetofolderfolder, parentWorkflow, result);
                }
            }
            entrystatus = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.Error", (String[])new String[]{e.toString()}));
        }
        finally {
            if (filename != null) {
                try {
                    filename.close();
                }
                catch (IOException iOException) {}
            }
        }
        return entrystatus;
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.nrErrors > 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrErrors >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    private void addFileToResultFilenames(String fileaddentry, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        try {
            ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)fileaddentry, (IVariables)this.getVariables()), parentWorkflow.getWorkflowName(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.isDebug()) {
                this.logDebug(" ------ ");
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FileAddedToResultFilesName", (String[])new String[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Error.AddingToFilenameResult", (String[])new String[0]), new Object[]{fileaddentry + e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDestinationFolder(FileObject filefolder) {
        FileObject folder = null;
        try {
            folder = this.destinationIsAFile ? filefolder.getParent() : filefolder;
            if (!folder.exists()) {
                if (this.createDestinationFolder) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FolderNotExist", (String[])new String[]{folder.getName().toString()}));
                    }
                    folder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FolderWasCreated", (String[])new String[]{folder.getName().toString()}));
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.FolderNotExist", (String[])new String[]{folder.getName().toString()}));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionMoveFiles.Log.CanNotCreateParentFolder", (String[])new String[]{folder.getName().toString()}), e);
        }
        finally {
            if (folder != null) {
                try {
                    folder.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private boolean getFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    private String getDestinationFilename(String shortsourcefilename) {
        Object shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = ((String)shortfilename).lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = ((String)shortfilename).substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Utils.isEmpty((CharSequence)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = (String)shortfilename + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = (String)shortfilename + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = (String)shortfilename + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = (String)shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    private String getMoveDestinationFilename(String shortsourcefilename, String dateFormat) {
        Object shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = ((String)shortfilename).lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = ((String)shortfilename).substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (dateFormat != null) {
            daf.applyPattern(dateFormat);
            String dt = daf.format(now);
            shortfilename = (String)shortfilename + dt;
        } else if (this.isSpecifyMoveFormat() && !Utils.isEmpty((CharSequence)this.getMovedDateTimeFormat())) {
            daf.applyPattern(this.getMovedDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = (String)shortfilename + dt;
        } else {
            if (this.isAddMovedDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = (String)shortfilename + "_" + d;
            }
            if (this.isAddMovedTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = (String)shortfilename + "_" + t;
            }
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = (String)shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    public void setAddDate(boolean adddate) {
        this.addDate = adddate;
    }

    public boolean isAddDate() {
        return this.addDate;
    }

    public boolean isAddMovedDate() {
        return this.addMovedDate;
    }

    public void setAddMovedDate(boolean addMovedDate) {
        this.addMovedDate = addMovedDate;
    }

    public boolean isAddMovedTime() {
        return this.addMovedTime;
    }

    public void setAddMovedTime(boolean addMovedTime) {
        this.addMovedTime = addMovedTime;
    }

    public void setIfFileExists(String ifFileExists) {
        this.ifFileExists = ifFileExists;
    }

    public String getIfFileExists() {
        return this.ifFileExists;
    }

    public void setIfMovedFileExists(String ifMovedFileExists) {
        this.ifMovedFileExists = ifMovedFileExists;
    }

    public String getIfMovedFileExists() {
        return this.ifMovedFileExists;
    }

    public void setAddTime(boolean addtime) {
        this.addTime = addtime;
    }

    public boolean isAddTime() {
        return this.addTime;
    }

    public void setAddDateBeforeExtension(boolean addDateBeforeExtension) {
        this.addDateBeforeExtension = addDateBeforeExtension;
    }

    public void setAddMovedDateBeforeExtension(boolean addMovedDateBeforeExtension) {
        this.addMovedDateBeforeExtension = addMovedDateBeforeExtension;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    public void setSpecifyMoveFormat(boolean specifyMoveFormat) {
        this.specifyMoveFormat = specifyMoveFormat;
    }

    public boolean isSpecifyMoveFormat() {
        return this.specifyMoveFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getMovedDateTimeFormat() {
        return this.movedDateTimeFormat;
    }

    public void setMovedDateTimeFormat(String movedDateTimeFormat) {
        this.movedDateTimeFormat = movedDateTimeFormat;
    }

    public boolean isAddDateBeforeExtension() {
        return this.addDateBeforeExtension;
    }

    public boolean isAddMovedDateBeforeExtension() {
        return this.addMovedDateBeforeExtension;
    }

    public boolean isDoNotKeepFolderStructure() {
        return this.doNotKeepFolderStructure;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setDoNotKeepFolderStructure(boolean doNotKeepFolderStructure) {
        this.doNotKeepFolderStructure = doNotKeepFolderStructure;
    }

    public void setMoveEmptyFolders(boolean moveEmptyFolders) {
        this.moveEmptyFolders = moveEmptyFolders;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setAddresultfilesname(boolean addResultFilenames) {
        this.addResultFilenames = addResultFilenames;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.argFromPrevious = argfrompreviousin;
    }

    public void setDestinationIsAFile(boolean destinationIsAFile) {
        this.destinationIsAFile = destinationIsAFile;
    }

    public void setCreateDestinationFolder(boolean createDestinationFolder) {
        this.createDestinationFolder = createDestinationFolder;
    }

    public void setCreateMoveToFolder(boolean createMoveToFolder) {
        this.createMoveToFolder = createMoveToFolder;
    }

    public void setNrErrorsLessThan(String nrErrorsLessThan) {
        this.nrErrorsLessThan = nrErrorsLessThan;
    }

    public String getNrErrorsLessThan() {
        return this.nrErrorsLessThan;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    public String getSuccessCondition() {
        return this.successCondition;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.sourceFileFolder.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public boolean isEvaluation() {
        return true;
    }
}

