/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class AzureKeyCredentialPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(AzureKeyCredentialPolicy.class);
    private final HttpHeaderName name;
    private final AzureKeyCredential credential;
    private final String prefix;

    public AzureKeyCredentialPolicy(String name, AzureKeyCredential credential) {
        this(name, credential, null);
    }

    public AzureKeyCredentialPolicy(String name, AzureKeyCredential credential, String prefix) {
        this(AzureKeyCredentialPolicy.validateName(name), Objects.requireNonNull(credential, "'credential' cannot be null."), prefix);
    }

    private static HttpHeaderName validateName(String name) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        if (name.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'name' cannot be empty."));
        }
        return HttpHeaderName.fromString(name);
    }

    AzureKeyCredentialPolicy(HttpHeaderName name, AzureKeyCredential credential, String prefix) {
        this.name = name;
        this.credential = credential;
        this.prefix = prefix != null ? prefix.trim() : null;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
        }
        this.setCredential(context.getHttpRequest().getHeaders());
        return next.process();
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
        }
        this.setCredential(context.getHttpRequest().getHeaders());
        return next.processSync();
    }

    void setCredential(HttpHeaders headers) {
        String credential = this.credential.getKey();
        headers.set(this.name, this.prefix == null ? credential : this.prefix + " " + credential);
    }
}

