/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.GroupMembershipInfo;
import com.dropbox.core.v2.sharing.InviteeMembershipInfo;
import com.dropbox.core.v2.sharing.UserMembershipInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SharedFolderMembers {
    @Nonnull
    protected final List<UserMembershipInfo> users;
    @Nonnull
    protected final List<GroupMembershipInfo> groups;
    @Nonnull
    protected final List<InviteeMembershipInfo> invitees;
    @Nullable
    protected final String cursor;

    public SharedFolderMembers(@Nonnull List<UserMembershipInfo> users, @Nonnull List<GroupMembershipInfo> groups, @Nonnull List<InviteeMembershipInfo> invitees, @Nullable String cursor) {
        if (users == null) {
            throw new IllegalArgumentException("Required value for 'users' is null");
        }
        for (UserMembershipInfo userMembershipInfo : users) {
            if (userMembershipInfo != null) continue;
            throw new IllegalArgumentException("An item in list 'users' is null");
        }
        this.users = users;
        if (groups == null) {
            throw new IllegalArgumentException("Required value for 'groups' is null");
        }
        for (GroupMembershipInfo groupMembershipInfo : groups) {
            if (groupMembershipInfo != null) continue;
            throw new IllegalArgumentException("An item in list 'groups' is null");
        }
        this.groups = groups;
        if (invitees == null) {
            throw new IllegalArgumentException("Required value for 'invitees' is null");
        }
        for (InviteeMembershipInfo inviteeMembershipInfo : invitees) {
            if (inviteeMembershipInfo != null) continue;
            throw new IllegalArgumentException("An item in list 'invitees' is null");
        }
        this.invitees = invitees;
        this.cursor = cursor;
    }

    public SharedFolderMembers(@Nonnull List<UserMembershipInfo> users, @Nonnull List<GroupMembershipInfo> groups, @Nonnull List<InviteeMembershipInfo> invitees) {
        this(users, groups, invitees, null);
    }

    @Nonnull
    public List<UserMembershipInfo> getUsers() {
        return this.users;
    }

    @Nonnull
    public List<GroupMembershipInfo> getGroups() {
        return this.groups;
    }

    @Nonnull
    public List<InviteeMembershipInfo> getInvitees() {
        return this.invitees;
    }

    @Nullable
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.users, this.groups, this.invitees, this.cursor});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFolderMembers other = (SharedFolderMembers)obj;
            return !(this.users != other.users && !this.users.equals(other.users) || this.groups != other.groups && !this.groups.equals(other.groups) || this.invitees != other.invitees && !this.invitees.equals(other.invitees) || this.cursor != other.cursor && (this.cursor == null || !this.cursor.equals(other.cursor)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedFolderMembers> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedFolderMembers value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("users");
            StoneSerializers.list(UserMembershipInfo.Serializer.INSTANCE).serialize(value.users, g);
            g.writeFieldName("groups");
            StoneSerializers.list(GroupMembershipInfo.Serializer.INSTANCE).serialize(value.groups, g);
            g.writeFieldName("invitees");
            StoneSerializers.list(InviteeMembershipInfo.Serializer.INSTANCE).serialize(value.invitees, g);
            if (value.cursor != null) {
                g.writeFieldName("cursor");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.cursor, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedFolderMembers deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_cursor;
            List<InviteeMembershipInfo> f_invitees;
            List<GroupMembershipInfo> f_groups;
            List<UserMembershipInfo> f_users;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_users = null;
                f_groups = null;
                f_invitees = null;
                f_cursor = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("users".equals(field)) {
                        f_users = StoneSerializers.list(UserMembershipInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("groups".equals(field)) {
                        f_groups = StoneSerializers.list(GroupMembershipInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("invitees".equals(field)) {
                        f_invitees = StoneSerializers.list(InviteeMembershipInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_users == null) {
                    throw new JsonParseException(p, "Required field \"users\" missing.");
                }
                if (f_groups == null) {
                    throw new JsonParseException(p, "Required field \"groups\" missing.");
                }
                if (f_invitees == null) {
                    throw new JsonParseException(p, "Required field \"invitees\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedFolderMembers value = new SharedFolderMembers(f_users, f_groups, f_invitees, f_cursor);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

