/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportTaskName
implements ResourceName {
    private static final PathTemplate PROPERTY_REPORT_TASK = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/reportTasks/{report_task}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String reportTask;

    @Deprecated
    protected ReportTaskName() {
        this.property = null;
        this.reportTask = null;
    }

    private ReportTaskName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.reportTask = (String)Preconditions.checkNotNull((Object)builder.getReportTask());
    }

    public String getProperty() {
        return this.property;
    }

    public String getReportTask() {
        return this.reportTask;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReportTaskName of(String property, String reportTask) {
        return ReportTaskName.newBuilder().setProperty(property).setReportTask(reportTask).build();
    }

    public static String format(String property, String reportTask) {
        return ReportTaskName.newBuilder().setProperty(property).setReportTask(reportTask).build().toString();
    }

    public static ReportTaskName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_REPORT_TASK.validatedMatch(formattedString, "ReportTaskName.parse: formattedString not in valid format");
        return ReportTaskName.of((String)matchMap.get("property"), (String)matchMap.get("report_task"));
    }

    public static List<ReportTaskName> parseList(List<String> formattedStrings) {
        ArrayList<ReportTaskName> list = new ArrayList<ReportTaskName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReportTaskName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReportTaskName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReportTaskName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_REPORT_TASK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReportTaskName reportTaskName = this;
            synchronized (reportTaskName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.reportTask != null) {
                        fieldMapBuilder.put((Object)"report_task", (Object)this.reportTask);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_REPORT_TASK.instantiate(new String[]{"property", this.property, "report_task", this.reportTask});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReportTaskName that = (ReportTaskName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.reportTask, that.reportTask);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reportTask);
    }

    public static class Builder {
        private String property;
        private String reportTask;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getReportTask() {
            return this.reportTask;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setReportTask(String reportTask) {
            this.reportTask = reportTask;
            return this;
        }

        private Builder(ReportTaskName reportTaskName) {
            this.property = reportTaskName.property;
            this.reportTask = reportTaskName.reportTask;
        }

        public ReportTaskName build() {
            return new ReportTaskName(this);
        }
    }
}

