/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins;

import java.util.Objects;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.metadata.api.HopMetadataProperty;

public abstract class ExecutionDataSamplerBase<Store extends IExecutionDataSamplerStore>
implements IExecutionDataSampler<Store> {
    @GuiWidgetElement(order="100", type=GuiElementType.TEXT, parentId="ExecutionDataSamplerParent", label="i18n::ExecutionDataSamplerBase.Label.SampleSize", toolTip="i18n::ExecutionDataSamplerBase.Tooltip.SampleSize")
    @HopMetadataProperty
    protected String sampleSize;
    protected String pluginId;
    protected String pluginName;

    public ExecutionDataSamplerBase() {
        this.sampleSize = "100";
    }

    public ExecutionDataSamplerBase(String sampleSize, String pluginId, String pluginName) {
        this.sampleSize = sampleSize;
        this.pluginId = pluginId;
        this.pluginName = pluginName;
    }

    public ExecutionDataSamplerBase(ExecutionDataSamplerBase<Store> base) {
        this.sampleSize = base.sampleSize;
        this.pluginId = base.pluginId;
        this.pluginName = base.pluginName;
    }

    @Override
    public abstract ExecutionDataSamplerBase<Store> clone();

    @Override
    public abstract Store createSamplerStore(ExecutionDataSamplerMeta var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionDataSamplerBase that = (ExecutionDataSamplerBase)o;
        return Objects.equals(this.pluginId, that.pluginId);
    }

    public int hashCode() {
        return Objects.hash(this.pluginId);
    }

    public String getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(String sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }
}

