/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class SliceExpression
extends ComputedExpression {
    Expression base;
    PositionRange range;

    public SliceExpression(Expression expression, PositionRange positionRange) {
        this.base = expression;
        this.range = positionRange;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(positionRange);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.typeCheck(staticContext, itemType);
        this.range = (PositionRange)this.range.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.optimize(optimizer, staticContext, itemType);
        this.range = (PositionRange)this.range.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.base = this.doPromotion(this.base, promotionOffer);
        }
        if (promotionOffer.action == 12 || promotionOffer.action == 14) {
            this.range = (PositionRange)this.doPromotion(this.range, promotionOffer);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.base.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        return this.base.getCardinality() | 0x2000;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.base, this.range);
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public boolean equals(Object object) {
        return object instanceof SliceExpression && this.base.equals(((SliceExpression)object).base) && this.range.equals(((SliceExpression)object).range);
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.base.iterate(xPathContext);
        return this.range.makePositionIterator(sequenceIterator, xPathContext);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "slice");
        this.base.display(n + 1, namePool, printStream);
        this.range.display(n + 1, namePool, printStream);
    }
}

