/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.AdapterMethodsFactory;
import com.squareup.moshi.ArrayJsonAdapter;
import com.squareup.moshi.ClassJsonAdapter;
import com.squareup.moshi.CollectionJsonAdapter;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.MapJsonAdapter;
import com.squareup.moshi.StandardJsonAdapters;
import com.squareup.moshi.Types;
import com.squareup.moshi.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Moshi {
    static final List<JsonAdapter.Factory> BUILT_IN_FACTORIES = new ArrayList<JsonAdapter.Factory>(5);
    private final List<JsonAdapter.Factory> factories;
    private final ThreadLocal<List<DeferredAdapter<?>>> reentrantCalls = new ThreadLocal();
    private final Map<Object, JsonAdapter<?>> adapterCache = new LinkedHashMap();

    Moshi(Builder builder) {
        ArrayList<JsonAdapter.Factory> factories = new ArrayList<JsonAdapter.Factory>(builder.factories.size() + BUILT_IN_FACTORIES.size());
        factories.addAll(builder.factories);
        factories.addAll(BUILT_IN_FACTORIES);
        this.factories = Collections.unmodifiableList(factories);
    }

    public <T> JsonAdapter<T> adapter(Type type) {
        return this.adapter(type, Util.NO_ANNOTATIONS);
    }

    public <T> JsonAdapter<T> adapter(Class<T> type) {
        return this.adapter(type, Util.NO_ANNOTATIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JsonAdapter<T> adapter(Type type, Set<? extends Annotation> annotations) {
        type = Types.canonicalize(type);
        Object cacheKey = this.cacheKey(type, annotations);
        Map<Object, JsonAdapter<?>> map = this.adapterCache;
        synchronized (map) {
            JsonAdapter<?> result = this.adapterCache.get(cacheKey);
            if (result != null) {
                return result;
            }
        }
        List<DeferredAdapter<?>> deferredAdapters = this.reentrantCalls.get();
        if (deferredAdapters != null) {
            int size = deferredAdapters.size();
            for (int i = 0; i < size; ++i) {
                DeferredAdapter<?> deferredAdapter = deferredAdapters.get(i);
                if (!deferredAdapter.cacheKey.equals(cacheKey)) continue;
                return deferredAdapter;
            }
        } else {
            deferredAdapters = new ArrayList();
            this.reentrantCalls.set(deferredAdapters);
        }
        DeferredAdapter deferredAdapter = new DeferredAdapter(cacheKey);
        deferredAdapters.add(deferredAdapter);
        try {
            int size = this.factories.size();
            for (int i = 0; i < size; ++i) {
                JsonAdapter<?> result = this.factories.get(i).create(type, annotations, this);
                if (result == null) continue;
                deferredAdapter.ready(result);
                Object object = this.adapterCache;
                synchronized (object) {
                    this.adapterCache.put(cacheKey, result);
                }
                object = result;
                return object;
            }
        }
        finally {
            deferredAdapters.remove(deferredAdapters.size() - 1);
            if (deferredAdapters.isEmpty()) {
                this.reentrantCalls.remove();
            }
        }
        throw new IllegalArgumentException("No JsonAdapter for " + type + " annotated " + annotations);
    }

    public <T> JsonAdapter<T> nextAdapter(JsonAdapter.Factory skipPast, Type type, Set<? extends Annotation> annotations) {
        type = Types.canonicalize(type);
        int skipPastIndex = this.factories.indexOf(skipPast);
        if (skipPastIndex == -1) {
            throw new IllegalArgumentException("Unable to skip past unknown factory " + skipPast);
        }
        int size = this.factories.size();
        for (int i = skipPastIndex + 1; i < size; ++i) {
            JsonAdapter<?> result = this.factories.get(i).create(type, annotations, this);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException("No next JsonAdapter for " + type + " annotated " + annotations);
    }

    public Builder newBuilder() {
        int fullSize = this.factories.size();
        int tailSize = BUILT_IN_FACTORIES.size();
        List<JsonAdapter.Factory> customFactories = this.factories.subList(0, fullSize - tailSize);
        return new Builder().addAll(customFactories);
    }

    private Object cacheKey(Type type, Set<? extends Annotation> annotations) {
        if (annotations.isEmpty()) {
            return type;
        }
        return Arrays.asList(type, annotations);
    }

    static {
        BUILT_IN_FACTORIES.add(StandardJsonAdapters.FACTORY);
        BUILT_IN_FACTORIES.add(CollectionJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(MapJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(ArrayJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(ClassJsonAdapter.FACTORY);
    }

    private static class DeferredAdapter<T>
    extends JsonAdapter<T> {
        Object cacheKey;
        private JsonAdapter<T> delegate;

        DeferredAdapter(Object cacheKey) {
            this.cacheKey = cacheKey;
        }

        void ready(JsonAdapter<T> delegate) {
            this.delegate = delegate;
            this.cacheKey = null;
        }

        @Override
        public T fromJson(JsonReader reader) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException("Type adapter isn't ready");
            }
            return this.delegate.fromJson(reader);
        }

        @Override
        public void toJson(JsonWriter writer, T value) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException("Type adapter isn't ready");
            }
            this.delegate.toJson(writer, value);
        }
    }

    public static final class Builder {
        final List<JsonAdapter.Factory> factories = new ArrayList<JsonAdapter.Factory>();

        public <T> Builder add(final Type type, final JsonAdapter<T> jsonAdapter) {
            if (type == null) {
                throw new IllegalArgumentException("type == null");
            }
            if (jsonAdapter == null) {
                throw new IllegalArgumentException("jsonAdapter == null");
            }
            return this.add(new JsonAdapter.Factory(){

                @Override
                public JsonAdapter<?> create(Type targetType, Set<? extends Annotation> annotations, Moshi moshi) {
                    return annotations.isEmpty() && Util.typesMatch(type, targetType) ? jsonAdapter : null;
                }
            });
        }

        public <T> Builder add(final Type type, final Class<? extends Annotation> annotation, final JsonAdapter<T> jsonAdapter) {
            if (type == null) {
                throw new IllegalArgumentException("type == null");
            }
            if (annotation == null) {
                throw new IllegalArgumentException("annotation == null");
            }
            if (jsonAdapter == null) {
                throw new IllegalArgumentException("jsonAdapter == null");
            }
            if (!annotation.isAnnotationPresent(JsonQualifier.class)) {
                throw new IllegalArgumentException(annotation + " does not have @JsonQualifier");
            }
            if (annotation.getDeclaredMethods().length > 0) {
                throw new IllegalArgumentException("Use JsonAdapter.Factory for annotations with elements");
            }
            return this.add(new JsonAdapter.Factory(){

                @Override
                public JsonAdapter<?> create(Type targetType, Set<? extends Annotation> annotations, Moshi moshi) {
                    if (Util.typesMatch(type, targetType) && annotations.size() == 1 && Util.isAnnotationPresent(annotations, annotation)) {
                        return jsonAdapter;
                    }
                    return null;
                }
            });
        }

        public Builder add(JsonAdapter.Factory factory) {
            this.factories.add(factory);
            return this;
        }

        public Builder add(Object adapter) {
            return this.add(AdapterMethodsFactory.get(adapter));
        }

        Builder addAll(List<JsonAdapter.Factory> factories) {
            this.factories.addAll(factories);
            return this;
        }

        public Moshi build() {
            return new Moshi(this);
        }
    }
}

