/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.javafilter;

import java.util.List;
import java.util.Objects;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.javafilter.JavaFilter;
import org.apache.hop.pipeline.transforms.javafilter.JavaFilterData;

@Transform(id="JavaFilter", image="javafilter.svg", name="i18n::JavaFilter.Name", description="i18n::JavaFilter.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", keywords={"i18n::JavaFilterMeta.keyword"}, documentationUrl="/pipeline/transforms/javafilter.html")
public class JavaFilterMeta
extends BaseTransformMeta<JavaFilter, JavaFilterData> {
    private static final Class<?> PKG = JavaFilterMeta.class;
    @HopMetadataProperty(key="condition", injectionKeyDescription="JavaFilterMeta.Injection.Condition")
    private String condition;
    @HopMetadataProperty(key="send_true_to", injectionKeyDescription="JavaFilterMeta.Injection.TrueTransform")
    private String trueTransform;
    @HopMetadataProperty(key="send_false_to", injectionKeyDescription="JavaFilterMeta.Injection.FalseTransform")
    private String falseTransform;

    public String getTrueTransform() {
        return this.trueTransform;
    }

    public void setTrueTransform(String trueTransform) {
        this.trueTransform = trueTransform;
    }

    public String getFalseTransform() {
        return this.falseTransform;
    }

    public void setFalseTransform(String falseTransform) {
        this.falseTransform = falseTransform;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public int hashCode() {
        return Objects.hash(this.getTransformIOMeta().getTargetStreams(), this.condition);
    }

    public Object clone() {
        JavaFilterMeta retval = (JavaFilterMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.condition = "true";
    }

    public void convertIOMetaToTransformNames() {
        List streams = this.getTransformIOMeta().getTargetStreams();
        this.trueTransform = Const.NVL((String)((IStream)streams.get(0)).getTransformName(), (String)"");
        this.falseTransform = Const.NVL((String)((IStream)streams.get(1)).getTransformName(), (String)"");
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List streams = this.getTransformIOMeta().getTargetStreams();
        ((IStream)streams.get(0)).setTransformMeta(TransformMeta.findTransform(transforms, (String)this.trueTransform));
        ((IStream)streams.get(1)).setTransformMeta(TransformMeta.findTransform(transforms, (String)this.falseTransform));
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int falseTargetIdx;
        int trueTargetIdx;
        CheckResult cr;
        Object errorMessage = "";
        List targetStreams = this.getTransformIOMeta().getTargetStreams();
        if (((IStream)targetStreams.get(0)).getTransformName() != null && ((IStream)targetStreams.get(1)).getTransformName() != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.BothTrueAndFalseTransformSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else if (((IStream)targetStreams.get(0)).getTransformName() == null && ((IStream)targetStreams.get(1)).getTransformName() == null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.NeitherTrueAndFalseTransformSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.PlsSpecifyBothTrueAndFalseTransform", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (((IStream)targetStreams.get(0)).getTransformName() != null && (trueTargetIdx = Const.indexOfString((String)((IStream)targetStreams.get(0)).getTransformName(), (String[])output)) < 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.TargetTransformInvalid", (String[])new String[]{"true", ((IStream)targetStreams.get(0)).getTransformName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (((IStream)targetStreams.get(1)).getTransformName() != null && (falseTargetIdx = Const.indexOfString((String)((IStream)targetStreams.get(1)).getTransformName(), (String[])output)) < 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.TargetTransformInvalid", (String[])new String[]{"false", ((IStream)targetStreams.get(1)).getTransformName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = Utils.isEmpty((CharSequence)this.condition) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.NoConditionSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.ConditionSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"JavaFilterMeta.InfoStream.True.Description", (String[])new String[0]), StreamIcon.TRUE, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"JavaFilterMeta.InfoStream.False.Description", (String[])new String[0]), StreamIcon.FALSE, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }
}

