/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.channel;

import com.google.common.base.Preconditions;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class S2AHandshakerServiceChannel {
    private static final Duration CHANNEL_SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private static final Logger logger = Logger.getLogger(S2AHandshakerServiceChannel.class.getName());

    public static SharedResourceHolder.Resource<Channel> getChannelResource(String s2aAddress, ChannelCredentials s2aChannelCredentials) {
        Preconditions.checkNotNull((Object)s2aAddress);
        return new ChannelResource(s2aAddress, s2aChannelCredentials);
    }

    private S2AHandshakerServiceChannel() {
    }

    private static class ChannelResource
    implements SharedResourceHolder.Resource<Channel> {
        private final String targetAddress;
        private final ChannelCredentials channelCredentials;

        public ChannelResource(String targetAddress, ChannelCredentials channelCredentials) {
            this.targetAddress = targetAddress;
            this.channelCredentials = channelCredentials;
        }

        public Channel create() {
            return ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)this.targetAddress, (ChannelCredentials)this.channelCredentials).directExecutor()).idleTimeout(5L, TimeUnit.SECONDS)).build();
        }

        public void close(Channel instanceChannel) {
            Preconditions.checkNotNull((Object)instanceChannel);
            ManagedChannel channel = (ManagedChannel)instanceChannel;
            channel.shutdownNow();
            try {
                channel.awaitTermination(CHANNEL_SHUTDOWN_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.log(Level.WARNING, "Channel to S2A was not shutdown.");
            }
        }

        public String toString() {
            return "grpc-s2a-channel";
        }
    }
}

