/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class PagesListInitNewPageRecord
extends InitNewPageRecord {
    @GridToStringExclude
    private final long prevPageId;
    @GridToStringExclude
    private final long addDataPageId;

    public PagesListInitNewPageRecord(int grpId, long pageId, int ioType, int ioVer, long newPageId, long prevPageId, long addDataPageId) {
        this(grpId, pageId, ioType, ioVer, newPageId, prevPageId, addDataPageId, null);
    }

    public PagesListInitNewPageRecord(int grpId, long pageId, int ioType, int ioVer, long newPageId, long prevPageId, long addDataPageId, @Nullable IgniteLogger log) {
        super(grpId, pageId, ioType, ioVer, newPageId, log);
        this.prevPageId = prevPageId;
        this.addDataPageId = addDataPageId;
    }

    public long previousPageId() {
        return this.prevPageId;
    }

    public long dataPageId() {
        return this.addDataPageId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PagesListNodeIO io = (PagesListNodeIO)PageIO.getPageIO(13, this.ioVer);
        PageMetrics metrics = pageMem.metrics().cacheGrpPageMetrics(this.groupId());
        io.initNewPage(pageAddr, this.pageId(), pageMem.realPageSize(this.groupId()), metrics);
        io.setPreviousId(pageAddr, this.prevPageId);
        if (this.addDataPageId != 0L) {
            int cnt = io.addPage(pageAddr, this.addDataPageId, pageMem.realPageSize(this.groupId()));
            assert (cnt == 0) : cnt;
        }
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGES_LIST_INIT_NEW_PAGE;
    }

    @Override
    public String toString() {
        return S.toString(PagesListInitNewPageRecord.class, this, "prevPageId", (Object)U.hexLong(this.prevPageId), "addDataPageId", (Object)U.hexLong(this.addDataPageId), "super", (Object)super.toString());
    }
}

