import { KubernetesLabelNames } from "./kubernetes/api";
import { OpenShiftLabelNames } from "./openshift/api";
export const BUILD_IMAGE_TAG_VERSION = "1.0";
export const ResourceLabelNames = {
    URI: "kogito.kie.org/uri",
    CREATED_BY: "kogito.kie.org/created-by",
    WORKSPACE_NAME: "kogito.kie.org/workspace-name",
};
export const commonLabels = (args) => ({
    [KubernetesLabelNames.APP]: args.resourceName,
    [KubernetesLabelNames.COMPONENT]: args.resourceName,
    [KubernetesLabelNames.INSTANCE]: args.resourceName,
    [KubernetesLabelNames.PART_OF]: args.resourceName,
    [KubernetesLabelNames.NAME]: args.resourceName,
    [ResourceLabelNames.CREATED_BY]: args.createdBy,
});
export const runtimeLabels = () => ({
    [OpenShiftLabelNames.RUNTIME]: "quarkus",
    [OpenShiftLabelNames.VERSION]: "openjdk-17-el7",
});
export var DeploymentState;
(function (DeploymentState) {
    DeploymentState["UP"] = "UP";
    DeploymentState["DOWN"] = "DOWN";
    DeploymentState["IN_PROGRESS"] = "IN_PROGRESS";
    DeploymentState["PREPARING"] = "PREPARING";
    DeploymentState["ERROR"] = "ERROR";
})(DeploymentState || (DeploymentState = {}));
export var ResourceDataSource;
(function (ResourceDataSource) {
    ResourceDataSource["PROVIDED"] = "PROVIDED";
    ResourceDataSource["TEMPLATE"] = "TEMPLATE";
})(ResourceDataSource || (ResourceDataSource = {}));
//# sourceMappingURL=common.js.map