import { CreateResourceFetchArgs, ResourceFetch, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { IService } from "kubernetes-models/v1";
import { ResourceDataSource, ResourceMetadataEnforcer } from "../common";
export type ServiceDescriptor = IService & ResourceMetadataEnforcer;
export type CreateServiceTemplateArgs = {
    resourceDataSource: ResourceDataSource.TEMPLATE;
};
export type CreateServiceArgs = CreateResourceFetchArgs & (CreateServiceTemplateArgs | {
    descriptor: ServiceDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const SERVICE_TEMPLATE: (args: CreateResourceFetchArgs & CreateServiceTemplateArgs) => ServiceDescriptor;
export declare class CreateService extends ResourceFetch {
    protected args: CreateServiceArgs;
    constructor(args: CreateServiceArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class ListServices extends ResourceFetch {
    method(): HttpMethod;
    endpoint(): string;
}
export declare class DeleteService extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    body(): string;
    method(): HttpMethod;
    endpoint(): string;
}
//# sourceMappingURL=Service.d.ts.map