"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var uniforms_1 = require("uniforms");
var invariant_1 = __importDefault(require("invariant"));
var BoolField_1 = __importDefault(require("./BoolField"));
var DateField_1 = __importDefault(require("./DateField"));
var ListField_1 = __importDefault(require("./ListField"));
var NestField_1 = __importDefault(require("./NestField"));
var NumField_1 = __importDefault(require("./NumField"));
var RadioField_1 = __importDefault(require("./RadioField"));
var SelectField_1 = __importDefault(require("./SelectField"));
var TextField_1 = __importDefault(require("./TextField"));
var AutoField = (0, uniforms_1.createAutoField)(function (props) {
    if (props.allowedValues) {
        return props.checkboxes && props.fieldType !== Array ? RadioField_1.default : SelectField_1.default;
    }
    switch (props.fieldType) {
        case Array:
            return ListField_1.default;
        case Boolean:
            return BoolField_1.default;
        case Date:
            return DateField_1.default;
        case Number:
            return NumField_1.default;
        case Object:
            return NestField_1.default;
        case String:
            return TextField_1.default;
    }
    return (0, invariant_1.default)(false, "Unsupported field type: %s", props.fieldType);
});
exports.default = AutoField;
//# sourceMappingURL=AutoField.js.map