import { useEffect, useLayoutEffect, useRef } from "react";
export function useEffectAfterFirstRender(func, deps) {
    const firstRender = useRef(true);
    useEffect(() => {
        if (!firstRender.current) {
            func();
        }
        else {
            firstRender.current = false;
        }
    }, [func, ...deps]);
}
export function useIsolatedEditorTogglingEffect(textMode, iframeContainer, githubTextEditorToReplace) {
    useLayoutEffect(() => {
        if (textMode) {
            githubTextEditorToReplace.classList.remove("hidden");
            iframeContainer.classList.add("hidden");
        }
        else {
            githubTextEditorToReplace.classList.add("hidden");
            iframeContainer.classList.remove("hidden");
        }
    }, [githubTextEditorToReplace.classList, iframeContainer.classList, textMode]);
}
export function useInitialAsyncCallEffect(promise, callback) {
    useEffect(() => {
        let canceled = false;
        promise().then((arg) => {
            if (canceled) {
                return;
            }
            callback(arg);
        });
        return () => {
            canceled = true;
        };
    }, [callback, promise]);
}
//# sourceMappingURL=customEffects.js.map