import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useEffect, useState } from "react";
import { useGlobals } from "../common/GlobalContext";
import { getOriginalFilePath, IsolatedPrEditor } from "./IsolatedPrEditor";
import { GitHubPageType } from "../../github/GitHubPageType";
export function PrEditorsApp(props) {
    const globals = useGlobals();
    const [prFileContainers, setPrFileContainers] = useState([]);
    useEffect(() => {
        setPrFileContainers(supportedPrFileElements(globals.logger, globals.envelopeLocator, globals.dependencies));
    }, [globals.dependencies, globals.envelopeLocator, globals.logger]);
    const mutationObserverTargetNode = useCallback(() => {
        if (props.pageType === GitHubPageType.PR_COMMITS) {
            return globals.dependencies.all.pr__commitsMutationObserverTarget();
        }
        else if (props.pageType === GitHubPageType.PR_FILES) {
            return globals.dependencies.all.pr__filesMutationObserverTarget();
        }
        else {
            return globals.dependencies.all.pr__homeMutationObserverTarget();
        }
    }, [globals.dependencies.all, props.pageType]);
    useEffect(() => {
        const observer = new MutationObserver((mutations) => {
            const addedNodes = mutations.reduce((l, r) => [...l, ...Array.from(r.addedNodes)], []);
            if (addedNodes.length <= 0) {
                return;
            }
            const newContainers = supportedPrFileElements(globals.logger, globals.envelopeLocator, globals.dependencies);
            if (newContainers.length === prFileContainers.length) {
                globals.logger.log("Found new unsupported containers");
                return;
            }
            globals.logger.log("Found new containers...");
            setPrFileContainers(newContainers);
        });
        observer.observe(mutationObserverTargetNode(), {
            childList: true,
            subtree: true,
        });
        return () => {
            observer.disconnect();
        };
    }, [globals.dependencies, globals.envelopeLocator, globals.logger, mutationObserverTargetNode, prFileContainers]);
    return (_jsx(_Fragment, { children: prFileContainers.map((container) => (_jsx(IsolatedPrEditor, { prInfo: props.prInfo, prFileContainer: container, fileExtension: getFileExtension(container, globals.dependencies), unprocessedFilePath: getUnprocessedFilePath(container, globals.dependencies), githubTextEditorToReplace: globals.dependencies.prView.githubTextEditorToReplaceElement(container) }, getUnprocessedFilePath(container, globals.dependencies)))) }));
}
function supportedPrFileElements(logger, envelopeLocator, dependencies) {
    return prFileElements(logger, dependencies).filter((container) => envelopeLocator.hasMappingFor(getFilePath(container, dependencies)));
}
function prFileElements(logger, dependencies) {
    const elements = dependencies.all.array.pr__supportedPrFileContainers();
    if (!elements) {
        logger.log("Could not find file containers...");
        return [];
    }
    return elements;
}
function getFileExtension(prFileContainer, dependencies) {
    const unprocessedFilePath = getUnprocessedFilePath(prFileContainer, dependencies);
    return getOriginalFilePath(unprocessedFilePath).split(".").pop();
}
function getFilePath(prFileContainer, dependencies) {
    const unprocessedFilePath = getUnprocessedFilePath(prFileContainer, dependencies);
    return getOriginalFilePath(unprocessedFilePath);
}
export function getUnprocessedFilePath(prFileContainer, dependencies) {
    return dependencies.all.pr__unprocessedFilePathContainer(prFileContainer).title;
}
//# sourceMappingURL=PrEditorsApp.js.map