import { GitHubPageType } from "./app/github/GitHubPageType";
import { renderSingleEditorApp } from "./app/components/single/singleEditorEdit";
import { iframeContainer, renderSingleEditorReadonlyApp } from "./app/components/single/singleEditorView";
import { renderPrEditorsApp } from "./app/components/pr/prEditors";
import { mainContainer, runAfterUriChange } from "./app/utils";
import { Dependencies } from "./app/Dependencies";
import * as ReactDOM from "react-dom";
import "../resources/style.css";
import { Logger } from "./Logger";
import { ResourceContentServiceFactory } from "./app/components/common/ChromeResourceContentService";
import { renderOpenRepoInExternalEditorApp } from "./app/components/openRepoInExternalEditor/openRepoInExternalEditorApp";
import { StateControl } from "@kie-tools-core/editor/dist/channel";
export function startExtension(args) {
    const logger = new Logger(args.name);
    const resourceContentServiceFactory = new ResourceContentServiceFactory();
    const dependencies = new Dependencies();
    const runInit = () => {
        var _a;
        const pageType = discoverCurrentGitHubPageType();
        const fileInfo = extractFileInfoFromUrl();
        const stateControl = new StateControl();
        init({
            id: chrome.runtime.id,
            logger: logger,
            dependencies: dependencies,
            githubAuthTokenCookieName: args.githubAuthTokenCookieName,
            extensionIconUrl: args.extensionIconUrl,
            editorEnvelopeLocator: args.editorEnvelopeLocator,
            resourceContentServiceFactory: resourceContentServiceFactory,
            externalEditorManager: args.externalEditorManager,
            stateControl,
            customChannelApiImpl: (_a = args.getCustomChannelApiImpl) === null || _a === void 0 ? void 0 : _a.call(args, pageType, fileInfo, stateControl),
        });
    };
    runAfterUriChange(logger, () => setTimeout(runInit, 0));
    setTimeout(runInit, 0);
}
function init(globals) {
    globals.logger.log(`---`);
    globals.logger.log(`Starting GitHub extension.`);
    unmountPreviouslyRenderedFeatures(globals.id, globals.logger, globals.dependencies, globals.editorEnvelopeLocator);
    const fileInfo = extractFileInfoFromUrl();
    const pageType = discoverCurrentGitHubPageType();
    if (!globals.dependencies.all.octiconMarkGitHub() || pageType === GitHubPageType.NOT_SUPPORTED) {
        globals.logger.warn(`This is not supported GitHub web page. '${window.location.origin}${window.location.pathname}'`);
        return;
    }
    if (pageType === GitHubPageType.EDIT) {
        renderSingleEditorApp({ ...globals, fileInfo });
    }
    else if (pageType === GitHubPageType.VIEW) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoFilesList()) {
            globals.logger.warn("The extension stopped working for this asset view. Please be sure you explore the asset with the latest GitHub instance.");
        }
        else {
            renderSingleEditorReadonlyApp({
                ...globals,
                pageType,
                className: "btn ml-2 d-none d-md-block",
                container: () => globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoFilesList(),
                fileInfo,
            });
        }
    }
    else if (pageType === GitHubPageType.PR_HOME ||
        pageType === GitHubPageType.PR_FILES ||
        pageType === GitHubPageType.PR_COMMITS) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnPrs()) {
            globals.logger.warn("The extension stopped working for this pull request view. Please be sure you explore the pull request on the latest GitHub instance.");
        }
        else {
            renderPrEditorsApp({
                ...globals,
                pageType,
                className: "btn btn-sm",
                container: () => globals.dependencies.openRepoInExternalEditor.buttonContainerOnPrs(),
            });
        }
    }
    else if (pageType === GitHubPageType.REPO_HOME) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome()) {
            globals.logger.warn("The extension stopped working for this repository view. Please be sure you explore the repository on the latest GitHub instance.");
        }
        else {
            renderOpenRepoInExternalEditorApp({
                ...globals,
                pageType,
                className: "btn btn-sm",
                container: () => globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome(),
            });
        }
    }
    else if (pageType === GitHubPageType.CAN_NOT_BE_DETERMINED_FROM_URL) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome()) {
            globals.logger.warn(`The extension stopped working for this view '${window.location.origin}${window.location.pathname}'. Please be sure you explore repository, asset or pull request on the latest GitHub instance.`);
        }
        else {
            renderOpenRepoInExternalEditorApp({
                ...globals,
                pageType,
                className: "btn btn-sm",
                container: () => globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome(),
            });
        }
    }
    else {
        throw new Error(`Unknown GitHubPageType ${pageType}`);
    }
}
export function extractFileInfoFromUrl() {
    const split = window.location.pathname.split("/");
    return {
        gitRef: split[4],
        repo: split[2],
        org: split[1],
        path: split.slice(5).join("/"),
    };
}
function unmountPreviouslyRenderedFeatures(id, logger, dependencies, editorEnvelopeLocator) {
    try {
        if (mainContainer(id, dependencies.all.body())) {
            ReactDOM.unmountComponentAtNode(mainContainer(id, dependencies.all.body()));
            logger.log("Unmounted previous features.");
        }
        switchHiddenCss(id, dependencies, editorEnvelopeLocator);
    }
    catch (e) {
        logger.log("Ignoring exception while unmounting features.");
    }
}
function pathnameMatches(regex) {
    return !!window.location.pathname.match(new RegExp(regex));
}
function switchHiddenCss(id, dependencies, editorEnvelopeLocator) {
    var _a, _b, _c;
    if (!editorEnvelopeLocator.getEnvelopeMapping(window.location.pathname)) {
        (_a = dependencies.singleView.githubTextEditorToReplaceElement()) === null || _a === void 0 ? void 0 : _a.classList.remove("hidden");
        (_b = iframeContainer(id, dependencies)) === null || _b === void 0 ? void 0 : _b.classList.add("hidden");
    }
    else {
        dependencies.singleView.githubTextEditorToReplaceElement().classList.add("hidden");
        (_c = iframeContainer(id, dependencies)) === null || _c === void 0 ? void 0 : _c.classList.remove("hidden");
    }
}
export function discoverCurrentGitHubPageType() {
    if (pathnameMatches(`.*/.*/edit/.*`)) {
        return GitHubPageType.EDIT;
    }
    if (pathnameMatches(`.*/.*/blob/.*`)) {
        return GitHubPageType.VIEW;
    }
    const isOrgSlashRepoSlashTreeSlashName = window.location.pathname.split("/tree/").length === 2 && !window.location.pathname.split("/tree/")[1].includes("/");
    if (isOrgSlashRepoSlashTreeSlashName) {
        return GitHubPageType.REPO_HOME;
    }
    if (pathnameMatches(`.*/.*/pull/[0-9]+/files.*`)) {
        return GitHubPageType.PR_FILES;
    }
    if (pathnameMatches(`.*/.*/pull/[0-9]+/commits.*`)) {
        return GitHubPageType.PR_COMMITS;
    }
    if (pathnameMatches(`^.*/.*/pull/[0-9]+$`)) {
        return GitHubPageType.PR_HOME;
    }
    if (["/tree/", "/pull/"].some((pathnamePart) => window.location.pathname.includes(pathnamePart))) {
        return GitHubPageType.NOT_SUPPORTED;
    }
    return GitHubPageType.CAN_NOT_BE_DETERMINED_FROM_URL;
}
export * from "./ExternalEditorManager";
//# sourceMappingURL=index.js.map