import { jsx as _jsx } from "react/jsx-runtime";
import { PopoverMenu } from "../../contextMenu/PopoverMenu";
import { PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import _ from "lodash";
import * as React from "react";
import { useCallback, useMemo } from "react";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import { MenuItemWithHelp } from "../../contextMenu/MenuWithHelp";
import { Menu } from "@patternfly/react-core/dist/js/components/Menu/Menu";
import { MenuGroup } from "@patternfly/react-core/dist/js/components/Menu/MenuGroup";
import { MenuList } from "@patternfly/react-core/dist/js/components/Menu/MenuList";
import { BoxedFunctionKind } from "../../api";
export const FunctionKindSelector = ({ selectedFunctionKind, onFunctionKindSelect, isReadOnly, }) => {
    var _a;
    const { editorRef } = useBoxedExpressionEditor();
    const functionKindSelectionCallback = useCallback((hide) => (event, itemId) => {
        onFunctionKindSelect(itemId);
        setVisibleHelp("");
        hide();
    }, [onFunctionKindSelect]);
    const functionKindHelp = useCallback((functionKind) => {
        switch (functionKind) {
            case "FEEL":
                return "Define function as a 'Friendly Enough Expression Language (FEEL)' expression. This is the default.";
            case "Java":
                return "Define the full qualified java class name and a public static method signature to invoke.\nThe method signature consists of the name of the method, followed by an argument list of the argument types.";
            case "PMML":
                return "Define 'Predictive Model Markup Language (PMML)' model to invoke.\nEditor parses and offers you all your PMML models from the workspace.";
            default:
                return "Not supported";
        }
    }, []);
    const [visibleHelp, setVisibleHelp] = React.useState("");
    const toggleVisibleHelp = useCallback((help) => {
        setVisibleHelp((previousHelp) => (previousHelp !== help ? help : ""));
    }, []);
    const displaySelectedFunctionKind = useMemo(() => (_jsx("div", { className: "selected-function-kind", "data-testid": "kie-tools--bee--selected-function-kind", children: _.first(selectedFunctionKind) })), [selectedFunctionKind]);
    if (isReadOnly) {
        return displaySelectedFunctionKind;
    }
    return (_jsx(PopoverMenu, { onHide: () => setVisibleHelp(""), appendTo: (_a = editorRef === null || editorRef === void 0 ? void 0 : editorRef.current) !== null && _a !== void 0 ? _a : undefined, className: "function-kind-popover", position: PopoverPosition.leftEnd, hasAutoWidth: true, body: (hide) => (_jsx(Menu, { onSelect: functionKindSelectionCallback(hide), selected: selectedFunctionKind, children: _jsx(MenuGroup, { className: "menu-with-help", children: _jsx(MenuList, { children: _.map(Object.entries(BoxedFunctionKind), ([functionKindKey, functionKind]) => (_jsx(MenuItemWithHelp, { menuItemKey: functionKind, menuItemHelp: functionKindHelp(functionKind), setVisibleHelp: toggleVisibleHelp, visibleHelp: visibleHelp }, functionKindKey))) }) }) })), children: displaySelectedFunctionKind }));
};
//# sourceMappingURL=FunctionKindSelector.js.map