import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover/Popover";
import HelpIcon from "@patternfly/react-icons/dist/js/icons/help-icon";
import * as React from "react";
import { useCallback, useEffect, useMemo } from "react";
import { Action, BeeTableHeaderVisibility, BeeTableOperation, BoxedFunctionKind, DmnBuiltInDataType, generateUuid, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { usePublishedBeeTableResizableColumns } from "../../resizing/BeeTableResizableColumnsContext";
import { useApportionedColumnWidthsIfNestedTable } from "../../resizing/Hooks";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { JAVA_FUNCTION_EXPRESSION_EXTRA_WIDTH, JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH, JAVA_FUNCTION_EXPRESSION_VALUES_COLUMN_WIDTH_INDEX, JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH, } from "../../resizing/WidthConstants";
import { BeeTable } from "../../table/BeeTable";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { useFunctionExpressionControllerCell, useFunctionExpressionParametersColumnHeader } from "./FunctionExpression";
import "./JavaFunctionExpression.css";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
export function JavaFunctionExpression({ functionExpression, isNested, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId, widthsById, isReadOnly } = useBoxedExpressionEditor();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const getClassContextEntry = useCallback((c) => {
        var _a;
        return (_a = c.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "class");
    }, []);
    const getVariableContextEntry = useCallback((c) => {
        var _a;
        return (_a = c.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === "method signature");
    }, []);
    const id = functionExpression["@_id"];
    const widths = useMemo(() => { var _a; return (_a = widthsById.get(id)) !== null && _a !== void 0 ? _a : []; }, [id, widthsById]);
    const getClassAndMethodNamesWidth = useCallback((widths) => {
        var _a;
        return (_a = widths[JAVA_FUNCTION_EXPRESSION_VALUES_COLUMN_WIDTH_INDEX]) !== null && _a !== void 0 ? _a : JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH;
    }, []);
    const classAndMethodNamesWidth = useMemo(() => getClassAndMethodNamesWidth(widths), [getClassAndMethodNamesWidth, widths]);
    const setClassAndMethodNamesWidth = useCallback((newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(getClassAndMethodNamesWidth(prev)) : newWidthAction;
            if (newWidth) {
                const minSize = JAVA_FUNCTION_EXPRESSION_VALUES_COLUMN_WIDTH_INDEX + 1;
                const newValues = [...prev];
                newValues.push(...Array(Math.max(0, minSize - newValues.length)).fill(JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH));
                newValues.splice(JAVA_FUNCTION_EXPRESSION_VALUES_COLUMN_WIDTH_INDEX, 1, newWidth);
                newMap.set(id, newValues);
            }
        });
    }, [getClassAndMethodNamesWidth, id, setWidthsById]);
    const parametersColumnHeader = useFunctionExpressionParametersColumnHeader(functionExpression.formalParameter, isReadOnly !== null && isReadOnly !== void 0 ? isReadOnly : false);
    const parametersId = useMemo(() => (functionExpression["@_id"] ? `${functionExpression["@_id"]}-parameters` : "parameters"), [functionExpression]);
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = functionExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: (_b = functionExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                isRowIndexColumn: false,
                width: undefined,
                columns: [
                    {
                        headerCellElement: parametersColumnHeader,
                        accessor: parametersId,
                        label: "parameters",
                        isRowIndexColumn: false,
                        dataType: undefined,
                        width: undefined,
                        columns: [
                            {
                                label: "label",
                                accessor: "label",
                                dataType: undefined,
                                isRowIndexColumn: false,
                                isWidthPinned: true,
                                isWidthConstant: true,
                                width: JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
                                minWidth: JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
                            },
                            {
                                label: "value",
                                accessor: "value",
                                dataType: undefined,
                                isRowIndexColumn: false,
                                width: classAndMethodNamesWidth,
                                setWidth: setClassAndMethodNamesWidth,
                                minWidth: JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH,
                            },
                        ],
                    },
                ],
            },
        ];
    }, [
        expressionHolderId,
        functionExpression,
        classAndMethodNamesWidth,
        parametersColumnHeader,
        setClassAndMethodNamesWidth,
        parametersId,
    ]);
    const headerVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.SecondToLastLevel : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        var _a, _b;
        const expressionChangedArgs = {
            action: Action.VariableChanged,
            variableUuid: expressionHolderId,
            typeChange: typeRef !== functionExpression["@_typeRef"]
                ? {
                    from: (_a = functionExpression["@_typeRef"]) !== null && _a !== void 0 ? _a : "",
                    to: typeRef,
                }
                : undefined,
            nameChange: name !== functionExpression["@_label"]
                ? {
                    from: (_b = functionExpression["@_label"]) !== null && _b !== void 0 ? _b : "",
                    to: name,
                }
                : undefined,
        };
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    "@_label": name,
                    "@_typeRef": typeRef,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [expressionHolderId, functionExpression, setExpression]);
    const context = functionExpression.expression;
    const clazz = getClassContextEntry(context);
    const method = getVariableContextEntry(context);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [{ name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy }],
            },
            {
                group: i18n.function.toUpperCase(),
                items: [{ name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset }],
            },
        ];
    }, [i18n]);
    const beeTableRows = useMemo(() => {
        var _a, _b, _c, _d, _e, _f;
        return [
            {
                label: "Class name",
                value: (_c = (_b = (_a = clazz === null || clazz === void 0 ? void 0 : clazz.expression) === null || _a === void 0 ? void 0 : _a.text) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "",
            },
            {
                label: "Method signature",
                value: (_f = (_e = (_d = method === null || method === void 0 ? void 0 : method.expression) === null || _d === void 0 ? void 0 : _d.text) === null || _e === void 0 ? void 0 : _e.__$$text) !== null && _f !== void 0 ? _f : "",
            },
        ];
    }, [clazz === null || clazz === void 0 ? void 0 : clazz.expression, method === null || method === void 0 ? void 0 : method.expression]);
    const controllerCell = useFunctionExpressionControllerCell(BoxedFunctionKind.Java);
    const getRowKey = useCallback((r) => {
        return r.id;
    }, []);
    const onRowReset = useCallback(() => {
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    expression: undefined,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowReset, rowIndex: 0 },
        });
    }, [setExpression]);
    const columns = useMemo(() => [
        {
            minWidth: JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
            width: JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH,
            isFrozen: true,
        },
        {
            minWidth: JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH,
            width: classAndMethodNamesWidth,
        },
    ], [classAndMethodNamesWidth]);
    const { onColumnResizingWidthChange, isPivoting, columnResizingWidths } = usePublishedBeeTableResizableColumns(functionExpression["@_id"], columns.length, true);
    const beeTableRef = React.useRef(null);
    useApportionedColumnWidthsIfNestedTable(beeTableRef, isPivoting, isNested, JAVA_FUNCTION_EXPRESSION_EXTRA_WIDTH, columns, columnResizingWidths, useMemo(() => [], []));
    useEffect(() => {
        var _a;
        (_a = beeTableRef.current) === null || _a === void 0 ? void 0 : _a.updateColumnResizingWidths(new Map([[1, { isPivoting: false, value: JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH }]]));
    }, []);
    const cellComponentByColumnAccessor = useMemo(() => ({
        label: (props) => _jsx(JavaFunctionExpressionLabelCell, { ...props }),
    }), []);
    const onCellUpdates = useCallback((cellUpdates) => {
        var _a, _b, _c, _d, _e, _f;
        for (const u of cellUpdates) {
            const context = functionExpression.expression;
            const clazz = (_a = getClassContextEntry(context)) !== null && _a !== void 0 ? _a : {
                "@_id": generateUuid(),
                expression: {
                    __$$element: "literalExpression",
                    "@_id": generateUuid(),
                    text: { __$$text: "" },
                },
                variable: {
                    "@_id": generateUuid(),
                    "@_name": "class",
                },
            };
            const method = (_b = getVariableContextEntry(context)) !== null && _b !== void 0 ? _b : {
                "@_id": generateUuid(),
                expression: {
                    __$$element: "literalExpression",
                    "@_id": generateUuid(),
                    text: { __$$text: "" },
                },
                variable: {
                    "@_id": generateUuid(),
                    "@_name": "method signature",
                },
            };
            if (u.rowIndex === 0) {
                setExpression({
                    setExpressionAction: (prev) => {
                        const ret = {
                            ...prev,
                            expression: {
                                __$$element: "context",
                                ...context,
                                contextEntry: [
                                    {
                                        ...clazz,
                                        expression: {
                                            ...clazz.expression,
                                            __$$element: "literalExpression",
                                            text: {
                                                __$$text: u.value,
                                            },
                                        },
                                    },
                                    method,
                                ],
                            },
                        };
                        return ret;
                    },
                    expressionChangedArgs: {
                        action: Action.LiteralTextExpressionChanged,
                        from: clazz.expression.__$$element === "literalExpression" ? (_d = (_c = clazz.expression.text) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "" : "",
                        to: u.value,
                    },
                });
            }
            else if (u.rowIndex === 1) {
                setExpression({
                    setExpressionAction: (prev) => {
                        var _a;
                        const ret = {
                            ...prev,
                            expression: {
                                __$$element: "context",
                                ...context,
                                contextEntry: [
                                    clazz,
                                    {
                                        ...method,
                                        expression: {
                                            ...method.expression,
                                            __$$element: "literalExpression",
                                            "@_id": (_a = method.expression["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(),
                                            text: {
                                                __$$text: u.value,
                                            },
                                        },
                                    },
                                ],
                            },
                        };
                        return ret;
                    },
                    expressionChangedArgs: {
                        action: Action.LiteralTextExpressionChanged,
                        from: method.expression.__$$element === "literalExpression" ? (_f = (_e = method.expression.text) === null || _e === void 0 ? void 0 : _e.__$$text) !== null && _f !== void 0 ? _f : "" : "",
                        to: u.value,
                    },
                });
            }
        }
    }, [functionExpression.expression, getClassContextEntry, getVariableContextEntry, setExpression]);
    const allowedOperations = useCallback((conditions) => {
        return [BeeTableOperation.SelectionCopy];
    }, []);
    return (_jsx("div", { className: `function-expression ${functionExpression["@_id"]}`, children: _jsx(BeeTable, { forwardRef: beeTableRef, isReadOnly: isReadOnly, onColumnResizingWidthChange: onColumnResizingWidthChange, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onColumnUpdates: onColumnUpdates, getRowKey: getRowKey, onRowReset: onRowReset, onCellUpdates: onCellUpdates, columns: beeTableColumns, rows: beeTableRows, headerLevelCountForAppendingRowIndexColumn: 2, skipLastHeaderGroup: true, cellComponentByColumnAccessor: cellComponentByColumnAccessor, headerVisibility: headerVisibility, controllerCell: controllerCell, shouldRenderRowIndexColumn: true, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false }) }));
}
function JavaFunctionExpressionLabelCell(props) {
    const label = useMemo(() => {
        return props.data[props.rowIndex].label;
    }, [props.data, props.rowIndex]);
    const { isActive } = useBeeTableSelectableCellRef(props.rowIndex, props.columnIndex, undefined, useCallback(() => label, [label]));
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject("");
        }
    }, [beeGwtService, isActive]);
    const getParameterLabelHelp = useCallback(() => {
        if (props.rowIndex === 0) {
            return _jsx("code", { children: "org.kie.kogito.MyClass" });
        }
        else {
            return _jsx("code", { children: "doSomething(java.lang.Integer, double)" });
        }
    }, [props.rowIndex]);
    const [isCellHovered, setIsCellHovered] = React.useState();
    return (_jsxs("div", { className: "java-function-expression-label", onMouseEnter: () => setIsCellHovered(true), onMouseLeave: () => setIsCellHovered(false), children: [_jsx("div", { className: "name", children: label }), _jsxs("div", { className: "data-type", children: [`(string)`, isCellHovered && (_jsx(Popover, { className: "java-function-parameter-help-popover", headerContent: label + " example", bodyContent: getParameterLabelHelp, children: _jsx(HelpIcon, { size: "sm", className: "java-function-parameter-help-icon" }) }))] })] }));
}
//# sourceMappingURL=JavaFunctionExpression.js.map