import * as React from "react";
export declare enum ResizerStopBehavior {
    SET_WIDTH_WHEN_SMALLER = 0,
    SET_WIDTH_ALWAYS = 1
}
export type ResizerRef = {
    width: number | undefined;
    setWidth?: React.Dispatch<React.SetStateAction<number | undefined>>;
    resizingWidth: ResizingWidth | undefined;
    resizerStopBehavior: ResizerStopBehavior;
};
export declare const DEFAULT_RESIZING_WIDTH: ResizingWidth;
export declare function ResizingWidthsContextProvider({ children }: React.PropsWithChildren<{}>): JSX.Element;
export type ResizingWidth = {
    value: number;
    isPivoting: boolean;
};
export type ResizingWidthsContextType = {
    resizingWidths: Map<string, ResizingWidth>;
};
export type ResizingWidthsDispatchContextType = {
    setResizing: (isResizing: boolean) => void;
    isResizing: () => boolean;
    updateResizingWidth(id: string, getNewResizingWidth: (prev: ResizingWidth | undefined) => ResizingWidth): void;
    registerResizerRef(ref: ResizerRef): ResizerRef;
    deregisterResizerRef(ref: ResizerRef): void;
    getResizerRefs(): Set<ResizerRef>;
};
export declare function useResizingWidths(): ResizingWidthsContextType;
export declare function useResizingWidthsDispatch(): ResizingWidthsDispatchContextType;
export declare function useResizerRef(resizerRef: ResizerRef): void;
//# sourceMappingURL=ResizingWidthsContext.d.ts.map