import * as React from "react";
import { BeeTableContextMenuAllowedOperationsConditions, BeeTableOperation, BeeTableOperationConfig, InsertRowColumnsDirection } from "../../api";
import * as ReactTable from "react-table";
import "./BeeTableContextMenuHandler.css";
export interface BeeTableContextMenuHandlerProps {
    tableRef: React.RefObject<HTMLDivElement | null>;
    operationConfig: BeeTableOperationConfig | undefined;
    allowedOperations: (conditions: BeeTableContextMenuAllowedOperationsConditions) => BeeTableOperation[];
    reactTableInstance: ReactTable.TableInstance<any>;
    onRowAdded?: (args: {
        beforeIndex: number;
        rowsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    onRowDuplicated?: (args: {
        rowIndex: number;
    }) => void;
    onRowReset?: (args: {
        rowIndex: number;
    }) => void;
    onRowDeleted?: (args: {
        rowIndex: number;
    }) => void;
    onColumnAdded?: (args: {
        beforeIndex: number;
        currentIndex: number;
        groupType: string | undefined;
        columnsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    onColumnDeleted?: (args: {
        columnIndex: number;
        groupType: string | undefined;
    }) => void;
    isReadOnly: boolean;
}
export declare function BeeTableContextMenuHandler({ tableRef, operationConfig, allowedOperations, reactTableInstance, onRowAdded, onRowDuplicated, onRowDeleted, onRowReset, onColumnAdded, onColumnDeleted, isReadOnly, }: BeeTableContextMenuHandlerProps): JSX.Element;
//# sourceMappingURL=BeeTableContextMenuHandler.d.ts.map