export class InternalFormDisplayerApiImpl {
    constructor(api, onOpenCallback) {
        this.wrapped = api;
        this.onOpenCallback = onOpenCallback;
    }
    onOpen(args) {
        if (this.onOpenCallback) {
            this.onOpenCallback(args.data, args.context);
        }
    }
    afterSubmit(response) {
        if (this.wrapped.afterSubmit) {
            this.wrapped.afterSubmit(response);
        }
    }
    beforeSubmit(context) {
        if (this.wrapped.beforeSubmit) {
            this.wrapped.beforeSubmit(context);
        }
    }
    getFormData() {
        if (this.wrapped.getFormData) {
            return this.wrapped.getFormData();
        }
        return null;
    }
}
export var SubmitResultType;
(function (SubmitResultType) {
    SubmitResultType["SUCCESS"] = "success";
    SubmitResultType["ERROR"] = "error";
})(SubmitResultType || (SubmitResultType = {}));
//# sourceMappingURL=InternalDisplayerApi.js.map