import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { getFormNameColumn, getDateColumn, getFormTypeColumn } from "../FormsListUtils/FormsListUtils";
import _ from "lodash";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
const FormsTable = ({ driver, formsData, setFormsData, isLoading, ouiaId, ouiaSafe, }) => {
    const [columns] = useState([
        getFormNameColumn((formData) => driver.openForm(formData)),
        getFormTypeColumn(),
        getDateColumn("lastModified", "Last Modified"),
    ]);
    const [sortBy, setSortBy] = useState({
        property: "lastModified",
        direction: "desc",
    });
    useEffect(() => {
        if (!_.isEmpty(formsData)) {
            onSort(2, "desc");
        }
    }, [isLoading]);
    const getSortBy = () => {
        return {
            index: columns.findIndex((column) => column.path === sortBy.property),
            direction: sortBy.direction,
        };
    };
    const onSort = async (index, direction) => {
        const sortObj = {
            property: columns[index].path,
            direction: direction,
        };
        const sortedData = _.orderBy(formsData, _.keys({
            [sortObj.property]: sortObj.direction,
        }), _.values({
            [sortObj.property]: sortObj.direction,
        }));
        setFormsData(sortedData);
        setSortBy(sortObj);
    };
    const formsLoadingComponent = (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Loading forms...", ouiaId: "forms-list-loading-forms" }) }));
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "forms-table", ouiaSafe), children: _jsx(DataTable, { data: formsData, isLoading: isLoading, columns: columns, error: false, sortBy: getSortBy(), onSorting: onSort, LoadingComponent: formsLoadingComponent }) }));
};
export default FormsTable;
//# sourceMappingURL=FormsTable.js.map