import { DmnBuiltInDataType, generateUuid, } from "@kie-tools/boxed-expression-component/dist/api";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH, CONTEXT_ENTRY_VARIABLE_MIN_WIDTH, DECISION_TABLE_ANNOTATION_DEFAULT_WIDTH, DECISION_TABLE_INPUT_DEFAULT_WIDTH, DECISION_TABLE_OUTPUT_DEFAULT_WIDTH, LITERAL_EXPRESSION_MIN_WIDTH, RELATION_EXPRESSION_COLUMN_DEFAULT_WIDTH, } from "@kie-tools/boxed-expression-component/dist/resizing/WidthConstants";
import { DECISION_TABLE_INPUT_DEFAULT_VALUE, DECISION_TABLE_OUTPUT_DEFAULT_VALUE, } from "@kie-tools/boxed-expression-component/dist/expressions/DecisionTableExpression/DecisionTableExpression";
import { INVOCATION_EXPRESSION_DEFAULT_PARAMETER_NAME } from "@kie-tools/boxed-expression-component/dist/expressions/InvocationExpression/InvocationExpression";
import { RELATION_EXPRESSION_DEFAULT_VALUE } from "@kie-tools/boxed-expression-component/dist/expressions/RelationExpression/RelationExpression";
import { isStruct } from "../dataTypes/DataTypeSpec";
export function getDefaultBoxedExpression({ logicType, typeRef, allTopLevelDataTypesByFeelName, widthsById, getInputs, getDefaultColumnWidth, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    const dataType = allTopLevelDataTypesByFeelName.get(typeRef !== null && typeRef !== void 0 ? typeRef : DmnBuiltInDataType.Undefined);
    if (logicType === "literalExpression") {
        const literalExpression = {
            __$$element: "literalExpression",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
        };
        widthsById.set(literalExpression["@_id"], [LITERAL_EXPRESSION_MIN_WIDTH]);
        return literalExpression;
    }
    else if (logicType === "functionDefinition") {
        const functionExpression = {
            __$$element: "functionDefinition",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            "@_kind": "FEEL",
            expression: undefined,
        };
        return functionExpression;
    }
    else if (logicType === "context") {
        let maxWidthBasedOnEntryNames = CONTEXT_ENTRY_VARIABLE_MIN_WIDTH;
        let contextEntries;
        if (!dataType || !isStruct(dataType.itemDefinition)) {
            contextEntries = [
                {
                    "@_id": generateUuid(),
                    variable: {
                        "@_id": generateUuid(),
                        "@_name": "ContextEntry-1",
                    },
                    expression: undefined,
                },
            ];
        }
        else {
            contextEntries = ((_a = dataType.itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : []).map((ic) => {
                var _a, _b;
                const name = ic["@_name"];
                const typeRef = isStruct(ic) ? DmnBuiltInDataType.Any : (_a = ic.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text;
                maxWidthBasedOnEntryNames = Math.max(maxWidthBasedOnEntryNames, (_b = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({ name, typeRef })) !== null && _b !== void 0 ? _b : CONTEXT_ENTRY_VARIABLE_MIN_WIDTH);
                return {
                    "@_id": generateUuid(),
                    variable: {
                        "@_id": generateUuid(),
                        "@_name": name,
                        "@_typeRef": typeRef,
                    },
                    expression: undefined,
                };
            });
        }
        contextEntries.push({
            "@_id": generateUuid(),
            expression: undefined,
        });
        const contextExpression = {
            __$$element: "context",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            contextEntry: contextEntries,
        };
        widthsById.set(contextExpression["@_id"], [maxWidthBasedOnEntryNames]);
        return contextExpression;
    }
    else if (logicType === "list") {
        const listExpression = {
            __$$element: "list",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            expression: [
                undefined,
            ],
        };
        return listExpression;
    }
    else if (logicType === "invocation") {
        const invocationExpression = {
            __$$element: "invocation",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            binding: [
                {
                    parameter: {
                        "@_id": generateUuid(),
                        "@_name": INVOCATION_EXPRESSION_DEFAULT_PARAMETER_NAME,
                        "@_typeRef": undefined,
                    },
                    expression: undefined,
                },
            ],
            expression: {
                __$$element: "literalExpression",
                "@_id": generateUuid(),
                text: { __$$text: "FUNCTION NAME" },
            },
        };
        widthsById.set(invocationExpression["@_id"], [CONTEXT_ENTRY_VARIABLE_MIN_WIDTH]);
        return invocationExpression;
    }
    else if (logicType === "relation") {
        const isSimple = !dataType || !isStruct(dataType.itemDefinition);
        const relationExpression = {
            __$$element: "relation",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            row: [
                {
                    "@_id": generateUuid(),
                    expression: [
                        {
                            __$$element: "literalExpression",
                            "@_id": generateUuid(),
                            text: { __$$text: RELATION_EXPRESSION_DEFAULT_VALUE },
                        },
                    ],
                },
            ],
            column: isSimple
                ? [
                    {
                        "@_id": generateUuid(),
                        "@_name": (_b = dataType === null || dataType === void 0 ? void 0 : dataType.itemDefinition["@_name"]) !== null && _b !== void 0 ? _b : "column-1",
                        "@_typeRef": dataType === null || dataType === void 0 ? void 0 : dataType.feelName,
                    },
                ]
                : ((_c = dataType.itemDefinition.itemComponent) !== null && _c !== void 0 ? _c : []).map((ic) => {
                    var _a;
                    const name = ic["@_name"];
                    const typeRef = isStruct(ic) ? DmnBuiltInDataType.Any : (_a = ic.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text;
                    return {
                        "@_id": generateUuid(),
                        "@_name": name,
                        "@_typeRef": typeRef,
                    };
                }),
        };
        widthsById.set(relationExpression["@_id"], [
            BEE_TABLE_ROW_INDEX_COLUMN_WIDTH,
            ...((_d = relationExpression.column) !== null && _d !== void 0 ? _d : []).map((c) => {
                var _a;
                return (_a = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({
                    name: c["@_name"],
                    typeRef: c["@_typeRef"],
                })) !== null && _a !== void 0 ? _a : RELATION_EXPRESSION_COLUMN_DEFAULT_WIDTH;
            }),
        ]);
        return relationExpression;
    }
    else if (logicType === "decisionTable") {
        const singleOutputColumn = {
            name: undefined,
            typeRef: dataType === null || dataType === void 0 ? void 0 : dataType.feelName,
        };
        const singleInputColumn = {
            name: "Input-1",
            typeRef: undefined,
        };
        const input = (_f = (_e = getInputs === null || getInputs === void 0 ? void 0 : getInputs()) === null || _e === void 0 ? void 0 : _e.map((input) => ({
            "@_id": generateUuid(),
            inputExpression: {
                "@_id": generateUuid(),
                text: { __$$text: input.name },
                "@_typeRef": input.typeRef,
            },
        }))) !== null && _f !== void 0 ? _f : [
            {
                "@_id": generateUuid(),
                inputExpression: {
                    "@_id": generateUuid(),
                    text: { __$$text: singleInputColumn.name },
                    "@_typeRef": singleInputColumn.typeRef,
                },
            },
        ];
        const output = !dataType || !isStruct(dataType.itemDefinition)
            ? [
                {
                    "@_id": generateUuid(),
                    "@_name": singleOutputColumn.name,
                    "@_typeRef": singleOutputColumn.typeRef,
                },
            ]
            : ((_g = dataType.itemDefinition.itemComponent) !== null && _g !== void 0 ? _g : []).map((ic) => {
                var _a;
                return ({
                    "@_id": generateUuid(),
                    "@_name": ic["@_name"],
                    "@_typeRef": isStruct(ic) ? DmnBuiltInDataType.Any : (_a = ic.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text,
                });
            });
        const decisionTableExpression = {
            __$$element: "decisionTable",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            "@_hitPolicy": "UNIQUE",
            input,
            output,
            annotation: [
                {
                    "@_name": "Annotations",
                },
            ],
            rule: [
                {
                    "@_id": generateUuid(),
                    inputEntry: input.map(() => ({
                        "@_id": generateUuid(),
                        text: { __$$text: DECISION_TABLE_INPUT_DEFAULT_VALUE },
                    })),
                    outputEntry: output.map(() => ({
                        "@_id": generateUuid(),
                        text: { __$$text: DECISION_TABLE_OUTPUT_DEFAULT_VALUE },
                    })),
                    annotationEntry: [{ text: { __$$text: "// Your annotations here" } }],
                },
            ],
        };
        widthsById.set(decisionTableExpression["@_id"], [
            BEE_TABLE_ROW_INDEX_COLUMN_WIDTH,
            ...((_h = decisionTableExpression.input) !== null && _h !== void 0 ? _h : []).map((input) => {
                var _a, _b, _c, _d, _e;
                return (_e = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({
                    name: (_d = (_b = (_a = input["@_label"]) !== null && _a !== void 0 ? _a : input.inputExpression["@_label"]) !== null && _b !== void 0 ? _b : (_c = input.inputExpression.text) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "",
                    typeRef: input.inputExpression["@_typeRef"],
                })) !== null && _e !== void 0 ? _e : DECISION_TABLE_INPUT_DEFAULT_WIDTH;
            }),
            ...((_j = decisionTableExpression.output) !== null && _j !== void 0 ? _j : []).map((output) => {
                var _a, _b, _c;
                return (_c = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({
                    name: (_b = (_a = output["@_label"]) !== null && _a !== void 0 ? _a : output["@_name"]) !== null && _b !== void 0 ? _b : "",
                    typeRef: output["@_typeRef"],
                })) !== null && _c !== void 0 ? _c : DECISION_TABLE_OUTPUT_DEFAULT_WIDTH;
            }),
            ...((_k = decisionTableExpression.annotation) !== null && _k !== void 0 ? _k : []).map(() => DECISION_TABLE_ANNOTATION_DEFAULT_WIDTH),
        ]);
        return decisionTableExpression;
    }
    else if (logicType === "conditional") {
        const conditionalExpression = {
            "@_id": generateUuid(),
            __$$element: "conditional",
            if: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            then: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            else: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return conditionalExpression;
    }
    else if (logicType === "for") {
        const forExpression = {
            "@_id": generateUuid(),
            __$$element: "for",
            return: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return forExpression;
    }
    else if (logicType == "some") {
        const someExpression = {
            "@_id": generateUuid(),
            __$$element: "some",
            satisfies: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return someExpression;
    }
    else if (logicType === "every") {
        const everyExpression = {
            "@_id": generateUuid(),
            __$$element: "every",
            satisfies: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return everyExpression;
    }
    else if (logicType === "filter") {
        const filterExpression = {
            "@_id": generateUuid(),
            __$$element: "filter",
            match: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return filterExpression;
    }
    else {
        throw new Error(`No default expression available for ${logicType}.`);
    }
}
//# sourceMappingURL=getDefaultBoxedExpression.js.map