import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { useDmnEditorStore } from "../store/StoreContext";
import { resolveTypeRef } from "./resolveTypeRef";
export function useResolvedTypeRef(typeRef, relativeToNamespace) {
    const { externalModelsByNamespace } = useExternalModels();
    return useDmnEditorStore((s) => {
        const thisDmnsNamespace = s.dmn.model.definitions["@_namespace"];
        return resolveTypeRef({
            typeRef: typeRef,
            namespace: relativeToNamespace || thisDmnsNamespace,
            allTopLevelDataTypesByFeelName: s.computed(s).getDataTypes(externalModelsByNamespace)
                .allTopLevelDataTypesByFeelName,
            externalModelsByNamespace,
            thisDmnsImportsByNamespace: s.computed(s).importsByNamespace(),
            relativeToNamespace: thisDmnsNamespace,
        });
    });
}
//# sourceMappingURL=useResolvedTypeRef.js.map