import { NODE_TYPES } from "../nodes/NodeTypes";
import { EDGE_TYPES } from "../edges/EdgeTypes";
export const graphStructure = new Map([
    [
        NODE_TYPES.inputData,
        new Map([
            [EDGE_TYPES.informationRequirement, new Set([NODE_TYPES.decision])],
            [EDGE_TYPES.authorityRequirement, new Set([NODE_TYPES.knowledgeSource])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.decision,
        new Map([
            [EDGE_TYPES.informationRequirement, new Set([NODE_TYPES.decision])],
            [EDGE_TYPES.authorityRequirement, new Set([NODE_TYPES.knowledgeSource])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.bkm,
        new Map([
            [EDGE_TYPES.knowledgeRequirement, new Set([NODE_TYPES.decision, NODE_TYPES.bkm])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.decisionService,
        new Map([
            [EDGE_TYPES.knowledgeRequirement, new Set([NODE_TYPES.decision, NODE_TYPES.bkm])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.knowledgeSource,
        new Map([
            [EDGE_TYPES.authorityRequirement, new Set([NODE_TYPES.decision, NODE_TYPES.bkm, NODE_TYPES.knowledgeSource])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.textAnnotation,
        new Map([
            [
                EDGE_TYPES.association,
                new Set([
                    NODE_TYPES.inputData,
                    NODE_TYPES.decision,
                    NODE_TYPES.bkm,
                    NODE_TYPES.decisionService,
                    NODE_TYPES.group,
                    NODE_TYPES.knowledgeSource,
                ]),
            ],
        ]),
    ],
    [
        NODE_TYPES.group,
        new Map([
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
]);
export const outgoingStructure = {
    [NODE_TYPES.inputData]: {
        nodes: outgoingNodes(NODE_TYPES.inputData),
        edges: outgoingEdges(NODE_TYPES.inputData),
    },
    [NODE_TYPES.decision]: {
        nodes: outgoingNodes(NODE_TYPES.decision),
        edges: outgoingEdges(NODE_TYPES.decision),
    },
    [NODE_TYPES.bkm]: {
        nodes: outgoingNodes(NODE_TYPES.bkm),
        edges: outgoingEdges(NODE_TYPES.bkm),
    },
    [NODE_TYPES.decisionService]: {
        nodes: outgoingNodes(NODE_TYPES.decisionService),
        edges: outgoingEdges(NODE_TYPES.decisionService),
    },
    [NODE_TYPES.knowledgeSource]: {
        nodes: outgoingNodes(NODE_TYPES.knowledgeSource),
        edges: outgoingEdges(NODE_TYPES.knowledgeSource),
    },
    [NODE_TYPES.group]: {
        nodes: outgoingNodes(NODE_TYPES.group),
        edges: outgoingEdges(NODE_TYPES.group),
    },
    [NODE_TYPES.textAnnotation]: {
        nodes: [],
        edges: outgoingEdges(NODE_TYPES.textAnnotation),
    },
};
export const containment = new Map([
    [NODE_TYPES.decisionService, new Set([NODE_TYPES.decision])],
]);
function outgoingNodes(srcNodeType) {
    var _a;
    return Array.from(((_a = graphStructure.get(srcNodeType)) !== null && _a !== void 0 ? _a : new Map()).values()).flatMap((tgt) => [...tgt]);
}
function outgoingEdges(srcNodeType) {
    var _a;
    return Array.from(((_a = graphStructure.get(srcNodeType)) !== null && _a !== void 0 ? _a : new Map()).keys());
}
export function getDefaultEdgeTypeBetween(source, target) {
    const edges = getEdgeTypesBetween(source, target);
    if (edges.length > 1) {
        console.debug(`Multiple edges possible for ${source} --> ${target}. Choosing first one in structure definition: ${edges[0]}.`);
    }
    return edges[0];
}
export function getEdgeTypesBetween(source, target) {
    const sourceStructure = graphStructure.get(source);
    if (!sourceStructure) {
        return [];
    }
    const possibleEdges = [];
    for (const [e, t] of [...sourceStructure.entries()]) {
        if (t.has(target)) {
            possibleEdges.push(e);
        }
    }
    return possibleEdges;
}
//# sourceMappingURL=graphStructure.js.map