import { useEffect, useState } from "react";
export function useIsHovered(ref) {
    const [isHovered, setHovered] = useState(false);
    useEffect(() => {
        function onEnter() {
            setHovered(true);
        }
        function onLeave() {
            setHovered(false);
        }
        const r = ref.current;
        r === null || r === void 0 ? void 0 : r.addEventListener("mouseenter", onEnter);
        r === null || r === void 0 ? void 0 : r.addEventListener("mouseleave", onLeave);
        return () => {
            r === null || r === void 0 ? void 0 : r.removeEventListener("mouseleave", onLeave);
            r === null || r === void 0 ? void 0 : r.removeEventListener("mouseenter", onEnter);
        };
    }, [ref]);
    return isHovered;
}
//# sourceMappingURL=useIsHovered.js.map