import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import "./Draggable.css";
import * as React from "react";
import { useState, useCallback, useContext, useMemo, useLayoutEffect } from "react";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import GripVerticalIcon from "@patternfly/react-icons/dist/js/icons/grip-vertical-icon";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export const DraggableStateContext = React.createContext({});
export const DraggableDispatchContext = React.createContext({});
export const DraggableItemContext = React.createContext({});
export function useDraggableStateContext() {
    return useContext(DraggableStateContext);
}
export function useDraggableDispatchContext() {
    return useContext(DraggableDispatchContext);
}
export function useDraggableItemContext() {
    return useContext(DraggableItemContext);
}
export function DragAndDrop({ reorder, onDragEnd, values, draggableItem, isDisabled, }) {
    var _a;
    const [source, setSource] = useState(-1);
    const [dest, setDest] = useState(-1);
    const [dragging, setDragging] = useState(false);
    const [origin, setOrigin] = useState(-1);
    const [leftOrigin, setLeftOrigin] = useState(false);
    const [valuesCopy, setValuesCopy] = useState(values !== null && values !== void 0 ? values : []);
    const [valuesKeys, setValuesKeys] = useState((_a = (values !== null && values !== void 0 ? values : [])) === null || _a === void 0 ? void 0 : _a.map((_) => generateUuid()));
    useLayoutEffect(() => {
        setValuesCopy((prev) => {
            var _a;
            if ((values === null || values === void 0 ? void 0 : values.length) !== prev.length) {
                setValuesKeys((_a = (values !== null && values !== void 0 ? values : [])) === null || _a === void 0 ? void 0 : _a.map((_) => generateUuid()));
            }
            return values !== null && values !== void 0 ? values : [];
        });
    }, [values, isDisabled]);
    const onInternalDragStart = useCallback((index) => {
        if (isDisabled) {
            return;
        }
        setDragging(true);
        setSource(index);
        setOrigin(index);
        setLeftOrigin(false);
    }, [isDisabled]);
    const onInternalDragOver = useCallback((e, index) => {
        if (isDisabled) {
            return;
        }
        e.preventDefault();
        setDest(index);
    }, [isDisabled]);
    const onInternalDragEnd = useCallback((index) => {
        if (isDisabled) {
            return;
        }
        onDragEnd === null || onDragEnd === void 0 ? void 0 : onDragEnd(origin, dest);
        setDragging(false);
        setSource(-1);
        setDest(-1);
        setOrigin(-1);
        setLeftOrigin(false);
    }, [dest, onDragEnd, origin, isDisabled]);
    const onInternalReorder = useCallback((source, dest) => {
        if (isDisabled) {
            return;
        }
        setValuesCopy((prev) => {
            const reordenedValues = [...prev];
            const [removedValue] = reordenedValues.splice(source, 1);
            reordenedValues.splice(dest, 0, removedValue);
            return reordenedValues;
        });
        setValuesKeys((prev) => {
            const reordenedKeys = [...prev];
            const [removedKeys] = reordenedKeys.splice(source, 1);
            reordenedKeys.splice(dest, 0, removedKeys);
            return reordenedKeys;
        });
    }, [isDisabled]);
    const onInternalDragEnter = useCallback((index) => {
        if (isDisabled) {
            return;
        }
        if (index === dest && index !== source) {
            reorder(source, dest);
            onInternalReorder(source, dest);
            setSource(dest);
            setDest(source);
        }
    }, [dest, reorder, source, onInternalReorder, isDisabled]);
    const onInternalDragLeave = useCallback((index) => {
        if (isDisabled) {
            return;
        }
        if (!leftOrigin && index !== source) {
            setLeftOrigin(true);
        }
    }, [leftOrigin, source, isDisabled]);
    return (_jsx(DraggableStateContext.Provider, { value: {
            source,
            dest,
            dragging,
            origin,
            leftOrigin,
        }, children: _jsx(DraggableDispatchContext.Provider, { value: {
                onDragStart: onInternalDragStart,
                onDragOver: onInternalDragOver,
                onDragEnd: onInternalDragEnd,
                onDragEnter: onInternalDragEnter,
                onDragLeave: onInternalDragLeave,
            }, children: valuesCopy === null || valuesCopy === void 0 ? void 0 : valuesCopy.map((value, index) => _jsx("div", { children: draggableItem === null || draggableItem === void 0 ? void 0 : draggableItem(value, index) }, valuesKeys[index])) }) }));
}
export function Draggable(props) {
    const { source, dragging, leftOrigin } = useDraggableStateContext();
    const { onDragStart, onDragOver, onDragEnd, onDragEnter, onDragLeave } = useDraggableDispatchContext();
    const [hoveredItem, setHoveredItem] = useState(-1);
    const [draggable, setDraggable] = useState(false);
    const hovered = useMemo(() => hoveredItem === props.index, [hoveredItem, props.index]);
    const isDragging = useMemo(() => props.index === source && leftOrigin, [leftOrigin, props.index, source]);
    const rowClassName = useMemo(() => {
        let className = "kie-dmn-editor--draggable-row";
        if (hovered) {
            className += " kie-dmn-editor--draggable-row-hovered";
        }
        if (isDragging) {
            className += " kie-dmn-editor--draggable-row-is-dragging";
        }
        return className;
    }, [hovered, isDragging]);
    return (_jsxs("div", { style: props.style, className: `${rowClassName} ${props.rowClassName ? props.rowClassName : ""}`, draggable: dragging || draggable, onDragStart: () => onDragStart(props.index), onDragOver: (e) => onDragOver(e, props.index), onDragEnd: () => {
            onDragEnd(props.index);
            setHoveredItem(-1);
        }, onDragLeave: () => onDragLeave(props.index), onDragEnter: () => onDragEnter(props.index), onPointerEnter: () => setHoveredItem(props.index), onPointerLeave: () => setHoveredItem(-1), onPointerOver: () => setHoveredItem(props.index), "data-testid": `kie-tools--dmn-editor--draggable-row-${props.index}`, children: [!props.isDisabled ? (_jsx("div", { "data-testid": "kie-tools--dmn-editor--draggable-icon", children: _jsx(Icon, { className: "kie-dmn-editor--draggable-icon", onPointerEnter: () => setDraggable(true), onPointerLeave: () => setDraggable(false), style: props.handlerStyle, children: _jsx(GripVerticalIcon, { className: hovered ? "kie-dmn-editor--draggable-icon-handler-hovered" : "kie-dmn-editor--draggable-icon-handler" }) }) })) : (_jsx("div", { style: { width: "36px" } })), _jsx("div", { style: props.childrenStyle, className: `kie-dmn-editor--draggable-children ${props.childrenClassName ? props.childrenClassName : ""}`, "data-testid": "kie-tools--dmn-editor--draggable-children", children: _jsx(DraggableItemContext.Provider, { value: { hovered }, children: props.children }) })] }));
}
//# sourceMappingURL=Draggable.js.map