import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { TypeRefLabel } from "../dataTypes/TypeRefLabel";
import { NodeIcon } from "../icons/Icons";
import { getNodeTypeFromDmnObject } from "../diagram/maths/DmnMaths";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useDmnEditorStore } from "../store/StoreContext";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
export function DmnObjectListItem({ dmnObject, dmnObjectHref, namespace, relativeToNamespace, }) {
    var _a, _b, _c, _d;
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const { externalModelsByNamespace } = useExternalModels();
    const allTopLevelDataTypesByFeelName = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName);
    const isAlternativeInputDataShape = useDmnEditorStore((s) => s.computed(s).isAlternativeInputDataShape());
    const isNamespaceDirectlyIncluded = useMemo(() => namespace === relativeToNamespace || importsByNamespace.has(namespace), [importsByNamespace, namespace, relativeToNamespace]);
    const transitivelyIncludedNamespaceDescription = useMemo(() => {
        return `${namespace.substring(0, 11)}...${namespace.substring(namespace.length - 4)}`;
    }, [namespace]);
    const displayName = useMemo(() => dmnObject && isNamespaceDirectlyIncluded
        ? buildFeelQNameFromNamespace({
            namedElement: dmnObject,
            importsByNamespace,
            namespace,
            relativeToNamespace,
        }).full
        : dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject["@_name"], [dmnObject, importsByNamespace, isNamespaceDirectlyIncluded, namespace, relativeToNamespace]);
    const nodeTypeTooltipDescription = useMemo(() => {
        if (dmnObject === undefined) {
            throw new Error("nodeTypeDescription can't be defined without a DMN object");
        }
        const nodeType = getNodeTypeFromDmnObject(dmnObject);
        if (nodeType === undefined) {
            throw new Error("Can't determine nodeTypeDescription with undefined node type");
        }
        if (nodeType === NODE_TYPES.decision) {
            return "Decision";
        }
        else if (nodeType === NODE_TYPES.inputData) {
            return "Input Data";
        }
        else {
            return "Unknown";
        }
    }, [dmnObject]);
    const toolTip = useMemo(() => {
        return dmnObject && isNamespaceDirectlyIncluded ? (_jsx("p", { children: displayName })) : (_jsx("div", { children: `This ${nodeTypeTooltipDescription} node is from an external model that is not included in this one. Namespace: ${namespace}` }));
    }, [displayName, dmnObject, isNamespaceDirectlyIncluded, namespace, nodeTypeTooltipDescription]);
    const isValid = useDmnEditorStore((s) => {
        var _a;
        return DMN15_SPEC.namedElement.isValidName((_a = dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(), displayName, s.computed(s).getAllFeelVariableUniqueNames());
    });
    const Icon = useMemo(() => {
        if (dmnObject === undefined) {
            throw new Error("Icon can't be defined without a DMN object");
        }
        const nodeType = getNodeTypeFromDmnObject(dmnObject);
        if (nodeType === undefined) {
            throw new Error("Can't determine node icon with undefined node type");
        }
        return NodeIcon({ nodeType, isAlternativeInputDataShape });
    }, [dmnObject, isAlternativeInputDataShape]);
    return !dmnObject ? (_jsx(_Fragment, { children: dmnObjectHref })) : (_jsx(Tooltip, { content: toolTip, isContentLeftAligned: true, children: _jsxs(Flex, { alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentFlexStart" }, spaceItems: { default: "spaceItemsNone" }, children: [_jsx("div", { style: { width: "40px", height: "40px", marginRight: 0 }, children: _jsx(Icon, {}) }), !isNamespaceDirectlyIncluded && (_jsx("div", { style: {
                        backgroundColor: "#f0f0f0",
                        color: "#6a6e72",
                    }, children: `${transitivelyIncludedNamespaceDescription}.` })), _jsx("div", { style: { color: isValid ? undefined : "red" }, children: `${displayName}` }), _jsx("div", { children: dmnObject.__$$element !== "knowledgeSource" ? (_jsxs(_Fragment, { children: ["\u00A0", _jsx(TypeRefLabel, { typeRef: (_a = dmnObject.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"], relativeToNamespace: namespace, isCollection: (_d = allTopLevelDataTypesByFeelName.get((_c = (_b = dmnObject.variable) === null || _b === void 0 ? void 0 : _b["@_typeRef"]) !== null && _c !== void 0 ? _c : DmnBuiltInDataType.Undefined)) === null || _d === void 0 ? void 0 : _d.itemDefinition["@_isCollection"] })] })) : (_jsx(_Fragment, {})) })] }) }));
}
//# sourceMappingURL=DmnObjectListItem.js.map