export function buildFeelQNameFromXmlQName({ namedElement, namedElementQName, importsByNamespace, relativeToNamespace, model, }) {
    if (!namedElementQName.prefix) {
        return { full: namedElement["@_name"], prefix: undefined, name: namedElement["@_name"], isExternal: false };
    }
    const namespace = model[`@_xmlns:${namedElementQName.prefix}`];
    if (!namespace) {
        throw new Error(`Can't find namespace declaration for namespace with name '${namedElementQName.prefix}'.`);
    }
    return buildFeelQNameFromNamespace({
        namedElement,
        namespace,
        importsByNamespace,
        relativeToNamespace,
    });
}
export function buildFeelQNameFromNamespace({ namedElement, namespace, importsByNamespace, relativeToNamespace, }) {
    if (relativeToNamespace === namespace) {
        return {
            full: namedElement["@_name"],
            prefix: undefined,
            name: namedElement["@_name"],
            isExternal: false,
        };
    }
    const _import = importsByNamespace.get(namespace);
    if (!_import) {
        throw new Error(`Can't find included model with namespace '${namespace}'.`);
    }
    if (_import["@_name"] === "") {
        return { full: namedElement["@_name"], prefix: undefined, name: namedElement["@_name"], isExternal: true };
    }
    return {
        full: `${_import["@_name"]}.${namedElement["@_name"]}`,
        prefix: _import["@_name"],
        name: namedElement["@_name"],
        isExternal: true,
    };
}
//# sourceMappingURL=buildFeelQName.js.map