import { allDmnImportNamespaces } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { allPmmlImportNamespaces, getPmmlNamespaceFromDmnImport } from "../pmml/pmml";
export function getNamespaceOfDmnImport({ dmnImport }) {
    if (allDmnImportNamespaces.has(dmnImport["@_importType"])) {
        return dmnImport["@_namespace"];
    }
    else if (allPmmlImportNamespaces.has(dmnImport["@_importType"])) {
        return getPmmlNamespaceFromDmnImport({ dmnImport });
    }
    else {
        return dmnImport["@_namespace"];
    }
}
//# sourceMappingURL=importNamespaces.js.map