import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { TextField, TextFieldType } from "../Fields";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
export function IteratorVariableCell(props) {
    var _a, _b, _c;
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    return (_jsx(_Fragment, { children: _jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Variable to interate over", placeholder: "Enter the variable name...", isReadOnly: props.isReadOnly, initialValue: (_b = cell["@_iteratorVariable"]) !== null && _b !== void 0 ? _b : "", expressionPath: (_c = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _c !== void 0 ? _c : [], onChange: (newVariable) => updater((dmnObject) => {
                dmnObject["@_iteratorVariable"] = newVariable;
            }) }) }));
}
//# sourceMappingURL=IteratorVariableCell.js.map