import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { InformationItemCell } from "./InformationItemCell";
export function RelationInformationItemCell(props) {
    var _a;
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    return (_jsx(_Fragment, { children: _jsx(InformationItemCell, { ...props, onDescriptionChange: (newDescription) => {
                updater((dmnObject) => {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                });
            }, onNameChange: (newName) => {
                updater((dmnObject) => {
                    dmnObject["@_name"] = newName;
                });
            }, onTypeRefChange: (newTypeRef) => {
                updater((dmnObject) => {
                    dmnObject["@_typeRef"] = newTypeRef;
                });
            } }) }));
}
//# sourceMappingURL=RelationInformationItemCell.js.map