import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { DocumentationLinksFormGroup } from "./DocumentationLinksFormGroup";
import { TypeRefSelector } from "../dataTypes/TypeRefSelector";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useDmnEditor } from "../DmnEditorContext";
import { useResolvedTypeRef } from "../dataTypes/useResolvedTypeRef";
import { useCallback, useMemo } from "react";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { useRefactor } from "../refactor/RefactorConfirmationDialog";
export function InputDataProperties({ inputData, namespace, index, }) {
    var _a, _b, _c;
    const { setState } = useDmnEditorStoreApi();
    const settings = useSettings();
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const isReadOnly = settings.isReadOnly || (!!namespace && namespace !== thisDmnsNamespace);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const resolvedTypeRef = useResolvedTypeRef((_a = inputData.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"], namespace);
    const identifierId = useMemo(() => inputData["@_id"], [inputData]);
    const oldName = useMemo(() => { var _a; return (_a = inputData["@_label"]) !== null && _a !== void 0 ? _a : inputData["@_name"]; }, [inputData]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog, newName } = useRefactor({
        index,
        identifierId,
        oldName,
    });
    const currentName = useMemo(() => {
        return newName === "" ? oldName : newName;
    }, [newName, oldName]);
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx(FormGroup, { label: "Name", children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: inputData["@_id"], name: currentName, isReadOnly: isReadOnly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: setNewIdentifierNameCandidate, allUniqueNames: useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []) }) }), _jsx(FormGroup, { label: "Data type", children: _jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, typeRef: resolvedTypeRef, isDisabled: isReadOnly, onChange: (newTypeRef) => {
                        setState((state) => {
                            var _a;
                            const drgElement = state.dmn.model.definitions.drgElement[index];
                            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": inputData["@_name"] });
                            drgElement.variable["@_typeRef"] = newTypeRef;
                        });
                    } }) }), _jsx(FormGroup, { label: "Description", children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: isReadOnly, value: (_b = inputData.description) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: (newDescription) => {
                        setState((state) => {
                            state.dmn.model.definitions.drgElement[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) }), _jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: inputData["@_id"] }) }), _jsx(DocumentationLinksFormGroup, { isReadOnly: isReadOnly, values: (_c = inputData.extensionElements) === null || _c === void 0 ? void 0 : _c["kie:attachment"], onChange: (newExtensionElements) => {
                    setState((state) => {
                        state.dmn.model.definitions.drgElement[index].extensionElements = {
                            "kie:attachment": newExtensionElements,
                        };
                    });
                } })] }));
}
//# sourceMappingURL=InputDataProperties.js.map